/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.utilty;

import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.common.utilty.PropertiesFileUtility;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RunLogger {
    public static final Logger PERF_LOGGER = LoggerFactory.getLogger((String)"com.huawei.vmf.adapter.perf.statistics");
    private static Pattern compile = Pattern.compile("com\\.huawei\\.vmf\\.\\w+");
    private static Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private static Properties logConfigProperties = PropertiesFileUtility.parse(ProcessInfoHelper.APP_PATH + File.separator + "conf" + File.separator + "logger_config.cfg");

    public static Properties loadLogConfigProperties() {
        return logConfigProperties;
    }

    public static Logger getLogger(Class<?> clazz) {
        String bundleName = RunLogger.getBundleName(clazz);
        Logger logger = loggers.get(bundleName);
        if (null != logger) {
            return logger;
        }
        logger = LoggerFactory.getLogger((String)bundleName);
        loggers.put(bundleName, logger);
        return logger;
    }

    private static String getBundleName(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        Matcher matcher = compile.matcher(packageName);
        if (!matcher.find()) {
            return packageName;
        }
        int bundleNamePrefixIndex = matcher.end();
        if (packageName.length() == bundleNamePrefixIndex) {
            return packageName;
        }
        int bundleNameIndex = packageName.indexOf(46, bundleNamePrefixIndex + 1);
        if (bundleNameIndex < 0) {
            return packageName;
        }
        return packageName.substring(0, bundleNameIndex);
    }

    static {
        if (null == logConfigProperties) {
            logConfigProperties = new Properties();
        }
    }
}

