/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.utilty;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileUtility.class);

    private PropertiesFileUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties parse(String file) {
        Properties configProperties = new Properties();
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            configProperties.load(f);
        }
        catch (Exception e) {
            LOGGER.error("load properties failed. filePath=" + file, (Throwable)e);
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("close load properties failed. filePath=" + file, (Throwable)e);
            }
        }
        return configProperties;
    }

    public static String getProperty(String file, String key) {
        Properties configProperties = PropertiesFileUtility.parse(file);
        return configProperties.getProperty(key);
    }

    public static String getProperty(Properties property, String key, String defaultValue) {
        return property.getProperty(key, defaultValue);
    }

    public static String getProperty(Properties configProperties, String key) {
        return configProperties.getProperty(key);
    }

    public static int getIntProperty(Properties configProperties, String key, int defaultValue) {
        String prop = configProperties.getProperty(key);
        int ret = defaultValue;
        if (prop != null) {
            try {
                ret = Integer.parseInt(prop);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("get int property exception, return default={}", (Object)defaultValue, (Object)e);
            }
        }
        return ret;
    }

    public static int getIntProperty(String file, String key) throws Exception {
        Properties configProperties = PropertiesFileUtility.parse(file);
        int result = Integer.parseInt(configProperties.getProperty(key));
        return result;
    }

    public static int getIntProperty(Properties configProperties, String key) throws Exception {
        int result = Integer.parseInt(configProperties.getProperty(key));
        return result;
    }
}

