/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.utilty;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public abstract class IpAddressUtil {
    public static final int IP_TUPLE_SIZE = 4;
    public static final String IPV6_IDENTIFY = ":";
    private static final int FIRST_TUPLE = 0;
    private static final int LAST_TUPLE = 3;
    private static final Logger logger = RunLogger.getLogger(IpAddressUtil.class);
    private static final String QASN_ZERO_MASK = "0";
    private static final int SECOND_TUPLE = 1;
    private static final int THIRD_TUPLE = 2;

    public static int dotMask2Int(String mask) throws IllegalArgumentException {
        if (QASN_ZERO_MASK.equals(mask)) {
            return 0;
        }
        String[] ss = mask.split("\\.");
        if (ss.length != 4) {
            throw new IllegalArgumentException("invalid mask " + mask);
        }
        long p1 = Long.parseLong(ss[0]);
        long p2 = Long.parseLong(ss[1]);
        long p3 = Long.parseLong(ss[2]);
        long p4 = Long.parseLong(ss[3]);
        long m = (p1 << 24) + (p2 << 16) + (p3 << 8) + p4;
        int bitCount = Long.bitCount(m);
        int trailingZeros = Long.numberOfTrailingZeros(m);
        if (trailingZeros == 64) {
            return 0;
        }
        if (bitCount + trailingZeros != 32) {
            throw new IllegalArgumentException("invalid mask " + mask);
        }
        return bitCount;
    }

    public static String getNetAddress(String ip, String mask) {
        if (!StringUtils.hasText((String)ip) || !StringUtils.hasText((String)mask)) {
            logger.debug("ip address is null or mask is null.");
            return "";
        }
        try {
            long ipValue = IpAddressUtil.ipAsLong(ip);
            long maskValue = IpAddressUtil.ipAsLong(mask);
            long netAddValue = ipValue & maskValue;
            return IpAddressUtil.longAsIp(netAddValue);
        }
        catch (UnknownHostException e) {
            logger.warn("illegal ip address:" + ip, (Throwable)e);
            return "";
        }
    }

    public static String intMask2DotMask(int mask) throws IllegalArgumentException {
        if (mask < 0 || mask > 32) {
            throw new IllegalArgumentException("invalid mask " + mask);
        }
        long i = 1L << mask;
        --i;
        int p1 = (int)(((i <<= 32 - mask) & 0xFFFFFFFFFF000000L) >> 24);
        int p2 = (int)((i & 0xFF0000L) >> 16);
        int p3 = (int)((i & 0xFF00L) >> 8);
        int p4 = (int)(i & 0xFFL);
        return "" + p1 + '.' + p2 + '.' + p3 + '.' + p4;
    }

    public static long ipAsLong(String ip) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(ip);
        byte[] tuples = inetAddress.getAddress();
        long address = 0L;
        address = tuples[3] & 0xFF;
        address |= (long)(tuples[2] << 8 & 0xFF00);
        address |= (long)(tuples[1] << 16 & 0xFF0000);
        return address |= (long)(tuples[0] << 24 & 0xFF000000);
    }

    public static boolean isIPV6(String ipAddress) {
        int position = ipAddress.indexOf(IPV6_IDENTIFY);
        return position > 0;
    }

    public static String long2Ip(long ip) throws VMFException {
        byte[] tuples = new byte[4];
        tuples[3] = (byte)(ip & 0xFFL);
        tuples[2] = (byte)((ip & 0xFF00L) >>> 8);
        tuples[1] = (byte)((ip & 0xFF0000L) >>> 16);
        tuples[0] = (byte)((ip & 0xFFFFFFFFFF000000L) >>> 24);
        try {
            InetAddress inetAddress = InetAddress.getByAddress(tuples);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new VMFException(603979967, (Throwable)e);
        }
    }

    @Deprecated
    public static String longAsIp(long ip) {
        byte[] tuples = new byte[4];
        tuples[3] = (byte)(ip & 0xFFL);
        tuples[2] = (byte)((ip & 0xFF00L) >>> 8);
        tuples[1] = (byte)((ip & 0xFF0000L) >>> 16);
        tuples[0] = (byte)((ip & 0xFFFFFFFFFF000000L) >>> 24);
        try {
            InetAddress inetAddress = InetAddress.getByAddress(tuples);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("input ip is not illegal.", e);
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i <= 32; ++i) {
            String mask = IpAddressUtil.intMask2DotMask(i);
            assert (i == IpAddressUtil.dotMask2Int(mask));
            System.out.println(mask + "\t" + IpAddressUtil.dotMask2Int(mask));
        }
    }
}

