/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.utilty;

import com.huawei.vmf.adapter.common.exception.VMFException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.FileSystemUtils;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public static void copy(File src, File dest) throws VMFException {
        try {
            FileSystemUtils.copyRecursively((File)src, (File)dest);
        }
        catch (IOException e) {
            LOGGER.error("Copy file error. SrcFilePath=" + src.getAbsolutePath() + ", destFilePath=" + dest.getAbsolutePath(), (Throwable)e);
            throw new VMFException(1107498880, "Copy file error. SrcFilePath=" + src.getAbsolutePath() + ", destFilePath=" + dest.getAbsolutePath(), e);
        }
    }

    public static void deleteFile(File file) {
        FileUtils.deleteQuietly((File)file);
    }

    public static File[] listFiles(File parentFile) {
        File[] childrenFiles = parentFile.listFiles();
        if (null == childrenFiles) {
            throw new IllegalArgumentException("Could not list files in directory: " + parentFile.getPath());
        }
        return childrenFiles;
    }

    public static void mkdir(File dir) throws VMFException {
        if (dir == null || dir.exists()) {
            return;
        }
        try {
            FileUtils.forceMkdir((File)dir);
            dir.setReadable(true, false);
            if (!dir.setWritable(true, false)) {
                LOGGER.error("unable set write permission to dir:{}", (Object)dir);
                throw new VMFException(1107498880, "set dir writable error. dir=" + dir);
            }
        }
        catch (IOException e) {
            throw new VMFException(1107498880, "mkdir error. dir=" + dir, e);
        }
    }

    public static void move(File src, File dest) throws VMFException {
        FileUtil.copy(src, dest);
        FileUtil.deleteFile(src);
    }

    public static String readFile(File file) {
        try {
            return FileCopyUtils.copyToString((Reader)new FileReader(file));
        }
        catch (IOException e) {
            LOGGER.error("read file to string exception.", (Throwable)e);
            return null;
        }
    }

    public static String readFile(InputStream in) throws IOException {
        return FileUtil.readFile(in, true);
    }

    public static String readFile(InputStream in, boolean closeIn) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        FileUtil.readBytes(in, out, closeIn);
        return out.toString("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readBytes(InputStream in, OutputStream out, boolean closeIn) throws IOException {
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = in.read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
                bytesRead = in.read(buffer);
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            if (closeIn) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error occurs while close InputStream.", (Throwable)e);
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                LOGGER.error("Error occurs while close OutputStream.", (Throwable)e);
            }
        }
    }
}

