/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.utilty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class CommonUtil {
    private static final String KEY_NULL_VALUE = "NULL";
    private static final String KEY_SEPARATOR = "/";

    public static <T> void addMap(Class moClass, T object, Map<Class, Collection<T>> map) {
        Collection<T> objects = map.get(moClass);
        if (null == objects) {
            objects = new ArrayList<T>();
            map.put(moClass, objects);
        }
        objects.add(object);
    }

    public static <T> void addMap(T object, Map<Class, Collection<T>> map) {
        Class<?> objectClass = object.getClass();
        Collection<T> objects = map.get(objectClass);
        if (null == objects) {
            objects = new ArrayList<T>();
            map.put(objectClass, objects);
        }
        objects.add(object);
    }

    public static String composeTmpKey(Object ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(KEY_SEPARATOR);
            sb.append(arg == null ? KEY_NULL_VALUE : arg.toString());
        }
        return sb.substring(KEY_SEPARATOR.length());
    }

    public static <T> List<T> genList(T ... objects) {
        if (ObjectUtils.isEmpty((Object[])objects)) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(objects.length);
        for (T object : objects) {
            list.add(object);
        }
        return list;
    }

    public static <T> Set<T> genSet(T ... objects) {
        if (ObjectUtils.isEmpty((Object[])objects)) {
            return Collections.emptySet();
        }
        HashSet<T> set = new HashSet<T>(objects.length);
        for (T object : objects) {
            set.add(object);
        }
        return set;
    }

    public static <T> Class<T> getClass(Collection<T> objects) {
        if (CollectionUtils.isEmpty(objects)) {
            return null;
        }
        return objects.iterator().next().getClass();
    }

    public static <E> void unNullAdd(E object, Collection<E> collection) {
        if (null == object) {
            return;
        }
        collection.add(object);
    }
}

