/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.utilty;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArea;
import com.huawei.network.qasn.m_q_ip_route_model.QAsnBgpPeer;
import com.huawei.network.qasn.m_q_ip_route_model.QAsnBgpPg;
import com.huawei.vmf.adapter.common.utilty.PropertiesFileUtility;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.commustru.fstru.FStruct;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsnUtil {
    public static final int DEFAULT_ATTRIBUTE_VALUE = -1;
    public static final String HEX_PREFIX = "0x";
    public static final BigInteger INVALID_BIGINTEGER_VALUE = BigInteger.valueOf(-1L);
    public static final int INVALID_INT_VALUE = -1;
    public static final long INVALID_LONG_VALUE = -1L;
    public static final int RADIX_HEX = 16;
    private static final int ASN_PRINT_DEFAULT_TRUNCATE = 10240000;
    private static int asnPrintTruncateSize = 10240000;
    private static final int DEFAULT_REQUEST_ASN_PRINT_TRUNCATE = 0x3200000;
    private static final int HEX_PREFIX_SIZE = 2;
    private static final String HEX_RE = "^0[Xx][0-9A-Fa-f]+";
    private static final Map<Class<?>, Set<String>> ignoreAsnFieldOnLog = new ConcurrentHashMap(new HashMap());
    private static Logger logger = LoggerFactory.getLogger(AsnUtil.class);
    private static final int MAX_RECURSIVE_DEEP = 10;
    private static final Map<Class<? extends FStruct>, Set<String>> pwdFields = new ConcurrentHashMap<Class<? extends FStruct>, Set<String>>();
    private static int requestAsnPrintTruncateSize = 0x3200000;

    public static BigInteger bigIntegerValue(Long l) {
        return AsnUtil.bigIntegerValue(l, -1L);
    }

    public static BigInteger bigIntegerValue(Long l, long defaultValue) {
        return null == l ? BigInteger.valueOf(defaultValue) : BigInteger.valueOf(l);
    }

    public static BigInteger bigIntegerValue(String s) {
        return BigInteger.valueOf(AsnUtil.longValue(s));
    }

    public static BigInteger chooseBigIntegerValue(byte[] bs, int i) {
        long value = AsnUtil.chooseLongValue(bs, i);
        return AsnUtil.bigIntegerValue(value);
    }

    public static long chooseLongValue(byte[] bs, int i) {
        String str = StringUtil.globalString(bs);
        if (StringUtil.isEmpty(str)) {
            return i;
        }
        return AsnUtil.longValue(bs);
    }

    public static int getAsnPrintTruncateSize() {
        return asnPrintTruncateSize;
    }

    public static byte[] getBytes(Number value) {
        if (null == value) {
            return new byte[0];
        }
        return StringUtil.globalByte(value.toString());
    }

    public static byte[] getBytes(String str) {
        if (null == str) {
            return new byte[0];
        }
        return StringUtil.globalByte(str);
    }

    public static int getRequestAsnPrintTruncateSize() {
        return requestAsnPrintTruncateSize;
    }

    public static Integer integerValue(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int intValue(BigInteger b) {
        return b == null ? -1 : b.intValue();
    }

    public static int intValue(Boolean bol) {
        return null == bol ? -1 : (bol != false ? 1 : 0);
    }

    public static Integer intValue(byte[] bytes) {
        return AsnUtil.intValue(AsnUtil.strValue(bytes));
    }

    public static int intValue(Integer i) {
        return AsnUtil.intValue(i, -1);
    }

    public static int intValue(Integer i, int defaultValue) {
        return i == null ? defaultValue : i;
    }

    public static int intValue(Long l) {
        return AsnUtil.intValue(l, -1);
    }

    public static int intValue(Long l, int defaultValue) {
        return null == l ? defaultValue : l.intValue();
    }

    public static int intValue(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int intValue(String s, int defaultValue) {
        if (StringUtils.isEmpty((String)s)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void linkFdnFragment(StrLinker linker, Integer fragment) {
        if (fragment != null && fragment != -1) {
            linker.append((long)fragment.intValue());
        } else {
            linker.append("");
        }
    }

    public static void linkFdnFragment(StrLinker linker, Long fragment) {
        if (fragment != null && fragment != -1L) {
            linker.append(fragment.longValue());
        } else {
            linker.append("");
        }
    }

    public static void linkFdnFragment(StrLinker linker, String fragment) {
        linker.append(fragment != null ? fragment : "");
    }

    public static long longValue(BigInteger bi) {
        return AsnUtil.longValue(bi, -1L);
    }

    public static long longValue(BigInteger bi, long defaultValue) {
        return null == bi ? defaultValue : bi.longValue();
    }

    public static long longValue(byte[] bytes) {
        return AsnUtil.longValue(AsnUtil.strValue(bytes));
    }

    public static long longValue(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static Boolean parseBoolean(Integer i) {
        if (null == i) {
            return Boolean.FALSE;
        }
        return 0 == i ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Integer parseInt(byte[] bytes) {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        String s = AsnUtil.strValue(bytes);
        try {
            return s.matches(HEX_RE) ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String parseIntToIP(int ip) {
        long longIP = AsnUtil.parseOverflowIntToLong(ip);
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIP >>> 24));
        sb.append('.');
        sb.append(String.valueOf((longIP & 0xFFFFFFL) >>> 16));
        sb.append('.');
        sb.append(String.valueOf((longIP & 0xFFFFL) >>> 8));
        sb.append('.');
        sb.append(String.valueOf(longIP & 0xFFL));
        return sb.toString();
    }

    public static Long parseLong(byte[] bytes) {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        String s = AsnUtil.strValue(bytes);
        try {
            return s.matches(HEX_RE) ? Long.parseLong(s.substring(2), 16) : Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long parseOverflowIntToLong(int i) {
        return Long.valueOf(Integer.toBinaryString(i), 2);
    }

    public static synchronized void registerIgnoreAsnFieldOnLog(Class<?> clazz, String fieldName) {
        Set<String> ff = ignoreAsnFieldOnLog.get(clazz);
        if (ff == null) {
            ff = new HashSet<String>();
            ignoreAsnFieldOnLog.put(clazz, ff);
        }
        ff.add(fieldName);
    }

    public static void setDefaultAsnValue(FStruct asn) {
        AsnUtil.recursiveSetAsnDefaultValue(asn, 0);
    }

    public static String strValue(BigInteger bi) {
        return null == bi ? null : String.valueOf(bi);
    }

    public static String strValue(byte[] bytes) {
        return StringUtil.globalString(bytes);
    }

    public static String strValue(Integer i) {
        return null == i ? null : String.valueOf(i);
    }

    public static String strValue(Long i) {
        return null == i ? null : String.valueOf(i);
    }

    public static String toStringAntiEmpty(byte[] bytes) {
        String tmpString = StringUtil.globalString(bytes);
        return null == tmpString || tmpString.isEmpty() ? null : tmpString;
    }

    @Deprecated
    public static String toString(FStruct asn) {
        return AsnUtil.toString(asn, AsnUtil.getAsnPrintTruncateSize());
    }

    public static String toString(FStruct asn, int truncateSize) {
        MyStringBuild stringBuilder = new MyStringBuild(truncateSize);
        try {
            AsnUtil.printAsn(asn, stringBuilder, new HashSet<Object>(), " ");
        }
        catch (IllegalArgumentException e) {
            logger.error("print asn {} exception", asn.getClass(), (Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error("print asn {} exception", asn.getClass(), (Object)e);
        }
        return stringBuilder.toString();
    }

    public static byte[] unsignedStrValue(Number value) {
        if (value == null || value.intValue() < 0) {
            return new byte[0];
        }
        return StringUtil.globalByte(value.toString());
    }

    private static void loadAsnPrintConfig() {
        Properties properties = RunLogger.loadLogConfigProperties();
        try {
            asnPrintTruncateSize = PropertiesFileUtility.getIntProperty(properties, "DEFAULT_ASN_PRINT_TRUNCATE", 10240000);
            logger.info("loadAsnPrintConfig asnPrintTruncateSize = " + asnPrintTruncateSize);
        }
        catch (Exception e) {
            logger.error("loadAsnPrintConfig exception " + e.getMessage());
        }
        try {
            requestAsnPrintTruncateSize = PropertiesFileUtility.getIntProperty(properties, "DEFAULT_REQUEST_ASN_PRINT_TRUNCATE", 0x3200000);
            logger.info("loadAsnPrintConfig requestAsnPrintTruncateSize = " + requestAsnPrintTruncateSize);
        }
        catch (Exception e) {
            logger.error("loadAsnPrintConfig exception " + e.getMessage());
        }
    }

    private static void printAsn(Object asn, MyStringBuild stringBuilder, Set<Object> printedObjects, String tag) throws IllegalArgumentException, IllegalAccessException {
        if (asn == null || asn instanceof FStruct && printedObjects.contains(asn)) {
            return;
        }
        if (!(asn instanceof FStruct)) {
            AsnUtil.printAsnValue(asn, stringBuilder);
            return;
        }
        printedObjects.add(asn);
        if (asn instanceof Vector) {
            AsnUtil.printAsnVector((Vector)asn, stringBuilder, printedObjects, tag);
            return;
        }
        Set<String> psdFileds = pwdFields.get(asn.getClass());
        stringBuilder.append('{');
        for (Field f : asn.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) break;
            Object value = f.get(asn);
            if (value == null) continue;
            stringBuilder.append(tag);
            stringBuilder.append(f.getName());
            stringBuilder.append(':');
            if (null != psdFileds && psdFileds.contains(f.getName())) {
                AsnUtil.printAsn("******", stringBuilder, printedObjects, tag + " ");
            } else {
                AsnUtil.printAsn(value, stringBuilder, printedObjects, tag + " ");
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append(tag);
        stringBuilder.append('}');
    }

    private static void printAsnValue(Object value, MyStringBuild stringBuilder) {
        if (byte[].class.isAssignableFrom(value.getClass())) {
            String ss = StringUtil.globalString((byte[])value);
            stringBuilder.append(ss);
            return;
        }
        String ss = value.toString();
        stringBuilder.append(ss);
    }

    private static void printAsnVector(Vector<?> vec, MyStringBuild stringBuilder, Set<Object> printedObjects, String tag) throws IllegalArgumentException, IllegalAccessException {
        stringBuilder.append("[");
        for (Object element : vec) {
            AsnUtil.printAsn(element, stringBuilder, printedObjects, tag + " ");
            stringBuilder.append("\n");
            stringBuilder.append(tag);
        }
        stringBuilder.append("]");
    }

    private static void recursiveSetAsnDefaultValue(FStruct asn, int deep) {
        if (asn == null || deep >= 10) {
            return;
        }
        byte[] defaultValue = new byte[]{};
        Class<?> clazz = asn.getClass();
        Field[] fields = clazz.getFields();
        try {
            for (Field field : fields) {
                FStruct subAsn;
                Class<?> fieldType = field.getType();
                if (byte[].class.isAssignableFrom(fieldType)) {
                    field.set(asn, defaultValue);
                    continue;
                }
                if (!FStruct.class.isAssignableFrom(fieldType) || Vector.class.isAssignableFrom(fieldType) || (subAsn = (FStruct)field.get(asn)) == null) continue;
                AsnUtil.setDefaultAsnValue(subAsn);
            }
        }
        catch (Exception e) {
            logger.info("set asn field byte[] = new byte[0] exception.", (Throwable)e);
        }
    }

    static {
        AsnUtil.loadAsnPrintConfig();
        pwdFields.put(QAsnArea.class, new HashSet<String>(Arrays.asList("authType", "passwd", "passwdType")));
        pwdFields.put(QAsnBgpPeer.class, new HashSet<String>(Arrays.asList("passwordType", "passwordText")));
        pwdFields.put(QAsnBgpPg.class, new HashSet<String>(Arrays.asList("passwordType", "passwordText")));
    }

    private static class MyStringBuild {
        private final int cap;
        private final StringBuilder stringBuilder = new StringBuilder();

        public MyStringBuild(int cap) {
            this.cap = cap;
        }

        public MyStringBuild append(char c) {
            if (this.leftCap() < 0) {
                return this;
            }
            this.stringBuilder.append(c);
            return this;
        }

        public MyStringBuild append(String ss) {
            if (this.leftCap() < 0) {
                return this;
            }
            this.stringBuilder.append(ss);
            return this;
        }

        public int leftCap() {
            return this.cap - this.stringBuilder.length();
        }

        public String toString() {
            return this.stringBuilder.toString();
        }
    }
}

