/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.imap;

import com.huawei.commextend.eventmgr.EventUtil;
import com.huawei.commextend.reliableevent.ReliableEvent;
import com.huawei.commextend.reliableevent.ReliableEventProxy;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.vmf.adapter.common.exception.MdpCommunicationException;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.imap.AsnNotifyMessage;
import com.huawei.vmf.adapter.common.imap.IMessageSession;
import com.huawei.vmf.adapter.common.imap.MSGCommon;
import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.extendpoint.framework.ISubMessageMgr;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import java.util.Deque;
import java.util.LinkedList;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdpSessionImpl
implements IMessageSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(MdpSessionImpl.class);
    protected Deque<AsnNotifyMessage> buffer = new LinkedList<AsnNotifyMessage>();
    private IProxyService mdpproxy;
    private EventUtil noReliableEventUtil;
    private ReliableEventProxy reliableProxy;

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public void emitNotification(MSGHead head, FStruct notify) {
        LOGGER.info("send out reliable message:[head={}, notify={}]", (Object)head, (Object)notify);
        ReliableEvent event = new ReliableEvent(head.cmdCode, notify);
        ReliableEventProxy reliableProxy = this.getReliableProxy();
        reliableProxy.send(event);
    }

    @Override
    public void flush() {
        IProxyService mdpproxy = this.getMdpproxy();
        ReliableEventProxy reliableProxy = this.getReliableProxy();
        for (AsnNotifyMessage message : this.buffer) {
            if (message.isReliable) {
                LOGGER.info("send out reliable message:[head={}, notify={}]", (Object)message.head, (Object)message.notify);
                ReliableEvent event = new ReliableEvent(message.head.cmdCode, message.notify);
                reliableProxy.send(event);
                continue;
            }
            LOGGER.info("send out mdp message:[head={}, notify={}]", (Object)message.head, (Object)message.notify);
            mdpproxy.sendResponseMessage(message.head, message.notify);
        }
    }

    public IProxyService getMdpproxy() {
        if (this.mdpproxy == null) {
            ProcessInfo procInfo = ProcessInfoHelper.getRuntimeProcessInfo();
            this.mdpproxy = MsgProxy.getProxyService((ProcessInfo)procInfo);
        }
        return this.mdpproxy;
    }

    public EventUtil getNoReliableEventUtil() {
        if (null == this.noReliableEventUtil) {
            this.noReliableEventUtil = EventUtil.getEventUtil((ProcessInfo)ProcessInfoHelper.getRuntimeProcessInfo());
        }
        return this.noReliableEventUtil;
    }

    public ReliableEventProxy getReliableProxy() {
        if (this.reliableProxy == null) {
            ProcessInfo procInfo = ProcessInfoHelper.getRuntimeProcessInfo();
            this.reliableProxy = ReliableEventProxy.getInstance((ProcessInfo)procInfo);
        }
        return this.reliableProxy;
    }

    @Override
    public int sendAyncMessage(char procID, byte taskMgrID, int cmdCode, FStruct req) {
        MSGHead head = MSGCommon.getMSGHead(procID, taskMgrID, cmdCode);
        head.msgType = (byte)6;
        LOGGER.info("send rpt asn:[procID={}, head={}, cmdCode={}, class={}, rpt={}]", new Object[]{Character.valueOf(procID), head, cmdCode, req.getClass().getName(), AsnUtil.toString(req)});
        return this.getMdpproxy().sendAsyncMessage(head, req, null);
    }

    @Override
    public int sendAyncMessage(int cmdCode, FStruct req) {
        if (req == null) {
            LOGGER.debug("can't send null message, drop it.");
        }
        IProxyService proxy = MsgProxy.getProxyService((ProcessInfo)ProcessInfoHelper.getRuntimeProcessInfo());
        int result = proxy.sendAsyncMessage(cmdCode, req, null, 60);
        LOGGER.debug("service.sendAsyncMessage result = ", (Object)result);
        return result;
    }

    @Override
    public void sendMessage(MSGHead head, FStruct req, FStruct resp, int timeout) throws MdpCommunicationException {
        if (req == null || head == null || resp == null) {
            LOGGER.debug("can't send null message, drop it.");
        }
        IProxyService proxy = MsgProxy.getProxyService((ProcessInfo)ProcessInfoHelper.getRuntimeProcessInfo());
        int rt = 0;
        rt = timeout > 0 ? proxy.sendMessage(head, req, resp, timeout) : proxy.sendMessage(head, req, resp, 60);
        if (rt != 0) {
            throw new MdpCommunicationException(rt, head);
        }
    }

    @Override
    public void sendMessageToClient(int cmdCode, FStruct message) throws VMFException {
        int ret = this.sendAyncMessage('\u0bbb', (byte)0, cmdCode, message);
        if (ret != 0) {
            throw new MdpCommunicationException(ret, MSGCommon.getMSGHead('\u0bbb', (byte)0, cmdCode));
        }
    }

    @Override
    public void sendNoReliableEvent(int eventID, FStruct content) throws VMFException {
        ISubMessageMgr subMsgObj = (ISubMessageMgr)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISubMessageMgr.class);
        if (subMsgObj != null) {
            subMsgObj.sendNoReliableEvent(eventID, content);
        } else {
            EventUtil eventUtil = this.getNoReliableEventUtil();
            eventUtil.postEvent(eventID, content);
        }
    }

    @Override
    public void sendNotification(AsnNotifyMessage message) {
        if (message == null) {
            LOGGER.debug("can't notify null message, drop it.");
            return;
        }
        this.buffer.offerLast(message);
        LOGGER.debug("buffer a mdp message:[head={}, notify={}]", (Object)message.head, message.notify.getClass());
    }

    @Override
    public void sendNotification(MSGHead head, FStruct notify) throws MdpCommunicationException {
        head.msgType = 1;
        int rt = this.getMdpproxy().sendResponseMessage(head, notify);
        LOGGER.info("send out mdp message:[head={}, notify={}, result={}]", new Object[]{head, notify.getClass(), rt});
        if (rt != 0) {
            throw new MdpCommunicationException(rt, head);
        }
    }

    @Override
    public void sendReliableEvent(int eventID, FStruct content) throws VMFException {
        if (content == null) {
            return;
        }
        ISubMessageMgr subMsgObj = (ISubMessageMgr)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISubMessageMgr.class);
        if (subMsgObj != null) {
            try {
                subMsgObj.sendReliableEvent(eventID, content);
            }
            catch (Exception e) {
                LOGGER.debug("construct subMsgObj failed!", (Throwable)e);
            }
        } else {
            LOGGER.info("send reliable event:[eventID={}, class={}]", new Object[]{eventID, content.getClass().getName()});
            ReliableEvent event = new ReliableEvent(eventID, content);
            ReliableEventProxy reliableProxy = this.getReliableProxy();
            reliableProxy.send(event);
        }
    }

    @Override
    public int sendResponseMessage(char procID, byte taskMgrID, int cmdCode, FStruct resp) {
        MSGHead head = MSGCommon.getMSGHead(procID, taskMgrID, cmdCode);
        head.msgType = (byte)7;
        LOGGER.info("send rpt asn:[head={}, rpt={}]", new Object[]{head, resp});
        return this.getMdpproxy().sendResponseMessage(head, resp);
    }

    @Override
    public int sendSyncMessage(char procID, byte taskMgrID, int cmdCode, FStruct req, FStruct resp) {
        return this.sendSyncMessage(procID, taskMgrID, cmdCode, req, resp, 60);
    }

    @Override
    public int sendSyncMessage(char procID, byte taskMgrID, int cmdCode, FStruct req, FStruct resp, int timeout) {
        if (req == null || resp == null) {
            LOGGER.debug("can't send null message, drop it.");
        }
        IProxyService proxy = MsgProxy.getProxyService((ProcessInfo)ProcessInfoHelper.getRuntimeProcessInfo());
        int rt = 0;
        MSGHead head = MSGCommon.getMSGHead(procID, taskMgrID, cmdCode);
        head.msgType = (byte)6;
        rt = timeout > 0 ? proxy.sendMessage(head, req, resp, timeout) : proxy.sendMessage(head, req, resp, 60);
        return rt;
    }

    public void setMdpproxy(IProxyService mdpproxy) {
        this.mdpproxy = mdpproxy;
    }

    public void setReliableProxy(ReliableEventProxy reliableProxy) {
        this.reliableProxy = reliableProxy;
    }
}

