/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.global;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class U2KInterfaceTypeMapping {
    public static final int ATM_SUBIF_TYPE = 65560;
    public static final int ATM_TRUNK_IF_TYPE = 65563;
    public static final int ATM_TYPE = 10000036;
    public static final int ATMBUNDLE_IF_TYPE = 202;
    public static final int AUX_IF_TYPE = 3842;
    public static final int CPOS_TRUNK_IF_TYPE = 65563;
    public static final int ETH_IF_TYPE = 1025;
    public static final int ETH_SUBIF_TYPE = 65559;
    public static final int ETH_TRUNK_IF_TYPE = 65539;
    public static final int IMA_IF_TYPE = 65537;
    public static final int INVALID_IF_TYPE = 0;
    public static final int IP_TRUNK_IF_TYPE = 65540;
    public static final int LOOPBACK_IF_TYPE = 65562;
    public static final int MP_GROUP_IF_TYPE = 65541;
    public static final int MTUNNEL_IF_TYPE = 65550;
    public static final int NULL_IF_TYPE = 1;
    public static final int PDH_IF_TYPE = 128;
    public static final int POS_IF_TYPE = 2049;
    public static final int REMOTE_AP_IF_TYPE = 65581;
    public static final int SERIAL_IF_TYPE = 65543;
    public static final int SIP_IF_TYPE = 1026;
    public static final int STACK_PORT_IF_TYPE = 65548;
    public static final int STMPORT_IF_TYPE = 2049;
    public static final int STMPORT_VC12_TYPE = 2050;
    public static final int STMPORT_VC4_TYPE = 2051;
    public static final int Tunnel_IF_TYPE = 65547;
    public static final int VBRIDGE_IF_TYPE = 65580;
    public static final int VE_IF_TYPE = 65549;
    public static final int VE_IF_SUBIF_TYPE = 65570;
    public static final int VLANIF_IF_TYPE = 65544;
    public static final int XGE = 1025;
    private static Map<Pattern, Integer> IFNAME_PORTTYPE_MAPPING;
    private static Map<Integer, String> INTERFACE_TYPE_MAPPING;
    private static Set<Integer> LP_TYPE_MAPPING;
    private static Set<Integer> PP_TYPE_MAPPING;
    private static Set<Integer> SUB_TYPE_MAPPING;
    private static Set<Integer> UNDELETEABLE_LP;
    private static Map<Integer, Integer> UNSUPPORTDEPLOY_TYPE_MAPPING;

    public static int getInterfaceTypeFromIfName(String ifName) {
        if (ifName == null) {
            return 0;
        }
        int ret = 0;
        for (Map.Entry<Pattern, Integer> entry : IFNAME_PORTTYPE_MAPPING.entrySet()) {
            if (!entry.getKey().matcher(ifName).find()) continue;
            ret = entry.getValue();
            break;
        }
        return ret;
    }

    public static Set<Integer> getLogicalInterfaceType() {
        return LP_TYPE_MAPPING;
    }

    public static Set<Integer> getPhysicalInterfaceType() {
        return PP_TYPE_MAPPING;
    }

    public static String getPortTypeName(int typeId) {
        return INTERFACE_TYPE_MAPPING.get(typeId);
    }

    public static Set<Integer> getSubInterfaceType() {
        return SUB_TYPE_MAPPING;
    }

    public static Set<Integer> getUndeleteableLogicIf() {
        return UNDELETEABLE_LP;
    }

    public static boolean isSupportDeploy(String ifname) {
        if (null == ifname) {
            return true;
        }
        int itype = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName(ifname);
        return !UNSUPPORTDEPLOY_TYPE_MAPPING.containsKey(itype);
    }

    static {
        INTERFACE_TYPE_MAPPING = new HashMap<Integer, String>();
        PP_TYPE_MAPPING = new HashSet<Integer>();
        PP_TYPE_MAPPING.add(1025);
        PP_TYPE_MAPPING.add(2049);
        PP_TYPE_MAPPING.add(128);
        PP_TYPE_MAPPING.add(1026);
        PP_TYPE_MAPPING.add(10000036);
        LP_TYPE_MAPPING = new HashSet<Integer>();
        LP_TYPE_MAPPING.add(65543);
        LP_TYPE_MAPPING.add(2051);
        LP_TYPE_MAPPING.add(2050);
        LP_TYPE_MAPPING.add(65539);
        LP_TYPE_MAPPING.add(65549);
        LP_TYPE_MAPPING.add(65544);
        LP_TYPE_MAPPING.add(65547);
        LP_TYPE_MAPPING.add(65537);
        LP_TYPE_MAPPING.add(65540);
        LP_TYPE_MAPPING.add(65562);
        LP_TYPE_MAPPING.add(1);
        LP_TYPE_MAPPING.add(65563);
        LP_TYPE_MAPPING.add(65563);
        LP_TYPE_MAPPING.add(65541);
        LP_TYPE_MAPPING.add(65548);
        LP_TYPE_MAPPING.add(65550);
        LP_TYPE_MAPPING.add(65580);
        LP_TYPE_MAPPING.add(65581);
        LP_TYPE_MAPPING.add(202);
        SUB_TYPE_MAPPING = new HashSet<Integer>();
        SUB_TYPE_MAPPING.add(65559);
        SUB_TYPE_MAPPING.add(65570);
        SUB_TYPE_MAPPING.add(65560);
        IFNAME_PORTTYPE_MAPPING = new HashMap<Pattern, Integer>();
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Cpos+|^Pos+"), 2049);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^VC4+"), 2051);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^VC12+"), 2050);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(100GE|40GE|10GE|GE|GigabitEthernet|Ethernet|MEth)([0-9/]+)$"), 1025);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(Sip)([0-9/]+)$"), 1026);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(ATM)([0-9/]+)$"), 10000036);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(Stack-Port)([0-9/]+)$"), 65548);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(100GE|40GE|10GE|GE|GigabitEthernet|Virtual-Ethernet|Eth-Trunk|Ethernet).*(\\.[\\d]+)$"), 65559);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Virtual-Ethernet([0-9/]+)$"), 65549);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(Global-VE+)([0-9/]+)$"), 65549);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(Global-VE).*(\\.[\\d]+)$"), 65570);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Eth-Trunk([0-9]+)$"), 65539);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Ip-Trunk"), 65540);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^NULL"), 1);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(LoopBack|InLoopBack)"), 65562);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Tunnel"), 65547);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(VlanIf|Vlanif)"), 65544);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^E1+|^T1+"), 128);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Serial"), 65543);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Mp-group"), 65541);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^MTunnel"), 65550);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Ima-group"), 65537);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^VBridge"), 65580);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Remote-Ap"), 65581);
        IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Atm-Bundle"), 202);
        INTERFACE_TYPE_MAPPING.put(2049, "Pos");
        INTERFACE_TYPE_MAPPING.put(1025, "GigabitEthernet");
        INTERFACE_TYPE_MAPPING.put(65559, "GigabitEthernet");
        INTERFACE_TYPE_MAPPING.put(65539, "Eth-Trunk");
        INTERFACE_TYPE_MAPPING.put(65540, "Ip-Trunk");
        INTERFACE_TYPE_MAPPING.put(1, "Other");
        INTERFACE_TYPE_MAPPING.put(65562, "LoopBack");
        INTERFACE_TYPE_MAPPING.put(65547, "Tunnel");
        INTERFACE_TYPE_MAPPING.put(65544, "VlanIf");
        INTERFACE_TYPE_MAPPING.put(65541, "Mp-group");
        INTERFACE_TYPE_MAPPING.put(1026, "Sip");
        INTERFACE_TYPE_MAPPING.put(10000036, "atm");
        INTERFACE_TYPE_MAPPING.put(65548, "Stack-Port");
        INTERFACE_TYPE_MAPPING.put(65550, "MTunnel");
        INTERFACE_TYPE_MAPPING.put(65580, "VBridge");
        INTERFACE_TYPE_MAPPING.put(65581, "Remote-Ap");
        INTERFACE_TYPE_MAPPING.put(202, "Atm-Bundle");
        INTERFACE_TYPE_MAPPING.put(65549, "Global-VE");
        INTERFACE_TYPE_MAPPING.put(65570, "Global-VE");
        UNSUPPORTDEPLOY_TYPE_MAPPING = new HashMap<Integer, Integer>();
        UNSUPPORTDEPLOY_TYPE_MAPPING.put(1025, 1);
        UNSUPPORTDEPLOY_TYPE_MAPPING.put(2049, 1);
        UNSUPPORTDEPLOY_TYPE_MAPPING.put(2049, 1);
        UNDELETEABLE_LP = new HashSet<Integer>();
        UNDELETEABLE_LP.add(65543);
    }
}

