/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class VsiUniResIDParser
extends AbstractUniResIDParser {
    public static final String TYPE = "VSI";
    private static final int VSI_ID_INDEX = 0;
    private static final int VSI_NAME_INDEX = 1;
    private int devID;
    private int vrID;
    private long vsiID;
    private String vsiName;

    public VsiUniResIDParser() {
    }

    public VsiUniResIDParser(int devID, int vrID, long vsiID, String vsiName) {
        this.devID = devID;
        this.vrID = vrID;
        this.vsiID = vsiID;
        this.vsiName = vsiName;
    }

    public VsiUniResIDParser(int devID, int vrID, String vsiName) {
        this.devID = devID;
        this.vrID = vrID;
        this.vsiName = vsiName;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        StrUIDParser parser = this.parseFdn(fdn, TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(TYPE));
        this.setValue(spliter);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    public int getVrID() {
        return this.vrID;
    }

    public long getVsiID() {
        return this.vsiID;
    }

    public String getVsiName() {
        return this.vsiName;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID && -1 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append(this.vsiID);
        linker.append(this.vsiName);
        factory.append(TYPE, linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setValue(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            if (0 == i) {
                this.vsiID = AsnUtil.longValue(spliter.strValue());
            }
            if (1 == i) {
                this.vsiName = spliter.strValue();
            }
            ++i;
        }
    }

    public void setVrID(Integer vrID) {
        if (null != vrID) {
            this.vrID = vrID;
        }
    }

    public void setVsiName(String vsiName) {
        this.vsiName = vsiName;
    }
}

