/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class VplsPwUniResIDParser
extends AbstractUniResIDParser {
    private static final int PEER_IP_INDEX = 4;
    private static final int PW_ID_INDEX = 0;
    private static final int VSI_NAME_INDEX = 5;
    private int devID;
    private String peerIp;
    private Long pwID;
    private int vrID;
    private String vsiName;

    public VplsPwUniResIDParser() {
    }

    public VplsPwUniResIDParser(int devID, int vrID, Long pwID, String peerIp, String vsiName) {
        this.devID = devID;
        this.vrID = vrID;
        this.pwID = pwID;
        this.peerIp = peerIp;
        this.vsiName = vsiName;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, this.getMOType());
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(this.getMOType()));
        this.setPwParas(spliter);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return "PW";
    }

    public String getPeerIp() {
        return this.peerIp;
    }

    public Long getPwID() {
        return this.pwID;
    }

    public int getVrID() {
        return this.vrID;
    }

    public String getVsiName() {
        return this.vsiName;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        AsnUtil.linkFdnFragment(linker, this.pwID);
        linker.append("");
        linker.append("");
        linker.append("");
        AsnUtil.linkFdnFragment(linker, this.peerIp);
        AsnUtil.linkFdnFragment(linker, this.vsiName);
        factory.append(this.getMOType(), linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setPwID(Long pwID) {
        this.pwID = pwID;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    private void setPwParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            switch (i) {
                case 0: {
                    int intPwID = Integer.parseInt(spliter.strValue());
                    this.pwID = AsnUtil.parseOverflowIntToLong(intPwID);
                    break;
                }
                case 4: {
                    this.peerIp = spliter.strValue();
                    break;
                }
                case 5: {
                    this.vsiName = spliter.strValue();
                    break;
                }
            }
            ++i;
        }
    }
}

