/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.extendpoint.framework.ISwitchTunnelName;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TunnelUniResIDParser
extends AbstractUniResIDParser {
    public static final String MOC_TYPE = "TUNNEL";
    private static final int DEST_IP_INDEX = 3;
    private static final int PROTOCOL_TYPE_INDEX = 1;
    private static final int TUNNEL_ID_INDEX = 4;
    private static final Logger logger = LoggerFactory.getLogger(TunnelUniResIDParser.class);
    private static final int TUNNEL_INDEX = 5;
    private int devID;
    private String lspDestAddr;
    private Integer protocolType;
    private String tunnelID;
    private String tunnelName;
    private int vrID;

    public TunnelUniResIDParser() {
    }

    public TunnelUniResIDParser(int devID, int vrID, String tunnelName) {
        this.devID = devID;
        this.vrID = vrID;
        this.tunnelName = tunnelName;
    }

    @Override
    public Object deserialize(String fdn) {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, MOC_TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(MOC_TYPE));
        this.setTnlParas(spliter);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    public String getLspDestAddr() {
        return this.lspDestAddr;
    }

    @Override
    public String getMOType() {
        return MOC_TYPE;
    }

    public Integer getProtocolType() {
        return this.protocolType;
    }

    public String getTunnelID() {
        return this.tunnelID;
    }

    public String getTunnelName() {
        String tunnelName;
        ISwitchTunnelName switchTunnelName = (ISwitchTunnelName)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISwitchTunnelName.class);
        if (switchTunnelName != null && (tunnelName = switchTunnelName.convertToVrpTunnelName(this.tunnelID)) != null) {
            return tunnelName;
        }
        return this.tunnelName;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() {
        ISwitchTunnelName switchTunnelName = (ISwitchTunnelName)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISwitchTunnelName.class);
        if (switchTunnelName != null) {
            try {
                String tunnelFdn = switchTunnelName.convertToTunnelFdnByDomain(this.devID, this.vrID, this.tunnelName);
                if (tunnelFdn != null) {
                    return tunnelFdn;
                }
            }
            catch (Exception e) {
                logger.error("construct tunnelFdn failed!", (Throwable)e);
            }
        }
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID && -1 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append(1L);
        if (this.getProtocolType() != null) {
            linker.append((long)this.getProtocolType().intValue());
        } else {
            linker.append("");
        }
        linker.append("");
        if (null != this.lspDestAddr) {
            linker.append(this.lspDestAddr);
        } else {
            linker.append("");
        }
        if (null == this.tunnelName) {
            linker.append("").append("").append("");
        } else {
            linker.append("").append(this.tunnelName).append("");
        }
        factory.append(MOC_TYPE, linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setLspDestAddr(String lspDestAddr) {
        this.lspDestAddr = lspDestAddr;
    }

    public void setProtocolType(Integer protocolType) {
        this.protocolType = protocolType;
    }

    public void setTunnelID(String tunnelID) {
        this.tunnelID = tunnelID;
    }

    public void setTunnelName(String tunnelName) {
        this.tunnelName = tunnelName;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    private void setTnlParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            if (3 == i) {
                this.lspDestAddr = spliter.strValue();
            } else if (4 == i) {
                this.setTunnelID(spliter.strValue());
            } else if (1 == i) {
                String str = spliter.strValue();
                if (StringUtils.hasText((String)str)) {
                    this.setProtocolType(Integer.valueOf(str));
                }
            } else if (5 == i) {
                this.tunnelName = spliter.strValue();
                break;
            }
            ++i;
        }
    }
}

