/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import org.springframework.util.StringUtils;

public class TunnelUniResIDForPtnParser
extends AbstractUniResIDParser {
    public static final String MOC_TYPE = "TUNNEL";
    private static final int TRANSPORT_TYPE_INDEX = 0;
    private static final int PROTOCOL_TYPE_INDEX = 1;
    private static final int EGRESS_LSR_ID_INDEX = 3;
    private static final int INGRESS_LSR_ID_INDEX = 2;
    private static final int TUNNEL_ID_INDEX = 4;
    private static final int LSR_ROLE_INDEX = 6;
    private static final int INVALID_VALUE = -1;
    private int devID;
    private int vrID;
    private Integer protocolType;
    private Integer transportType;
    private String egressLsrId;
    private String ingressLsrId;
    private Integer tunnelID;
    private Integer lsrRole;

    @Override
    public Object deserialize(String fdn) {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, MOC_TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(MOC_TYPE));
        this.setTnlParas(spliter);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return MOC_TYPE;
    }

    public Integer getProtocolType() {
        return this.protocolType;
    }

    public Integer getTunnelID() {
        return this.tunnelID;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID && -1 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append(this.getParamValue(this.transportType));
        linker.append(this.getParamValue(this.protocolType));
        linker.append(this.getParamValue(this.ingressLsrId));
        linker.append(this.getParamValue(this.egressLsrId));
        linker.append(this.getParamValue(this.tunnelID));
        linker.append("");
        linker.append(this.getParamValue(this.lsrRole));
        factory.append(MOC_TYPE, linker.getStr());
        return factory.getStr();
    }

    private String getParamValue(String value) {
        return value == null ? "" : value;
    }

    private String getParamValue(Integer value) {
        return value == null || -1 == value ? "" : value.toString();
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    private void setTnlParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            String str;
            if (0 == i) {
                str = spliter.strValue();
                if (StringUtils.hasText((String)str)) {
                    this.setTransportType(Integer.valueOf(str));
                }
            } else if (1 == i) {
                str = spliter.strValue();
                if (StringUtils.hasText((String)str)) {
                    this.setProtocolType(Integer.valueOf(str));
                }
            } else if (2 == i) {
                this.setIngressLsrId(spliter.strValue());
            } else if (3 == i) {
                this.setEgressLsrId(spliter.strValue());
            } else if (4 == i) {
                str = spliter.strValue();
                if (StringUtils.hasText((String)str)) {
                    this.setTunnelID(Integer.valueOf(str));
                }
            } else if (6 == i && StringUtils.hasText((String)(str = spliter.strValue()))) {
                Integer lsrType = Integer.valueOf(str);
                this.setLsrRole(lsrType);
            }
            ++i;
        }
    }

    public Integer getTransportType() {
        return this.transportType;
    }

    public void setTransportType(Integer transportType) {
        this.transportType = transportType;
    }

    public String getEgressLsrId() {
        return this.egressLsrId;
    }

    public void setEgressLsrId(String egressLsrId) {
        this.egressLsrId = egressLsrId;
    }

    public String getIngressLsrId() {
        return this.ingressLsrId;
    }

    public void setIngressLsrId(String ingressLsrId) {
        this.ingressLsrId = ingressLsrId;
    }

    public Integer getLsrRole() {
        return this.lsrRole;
    }

    public void setLsrRole(Integer lsrRole) {
        this.lsrRole = lsrRole;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    public void setProtocolType(Integer protocolType) {
        this.protocolType = protocolType;
    }

    public void setTunnelID(Integer tunnelID) {
        this.tunnelID = tunnelID;
    }
}

