/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.InterfaceUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.UniResIDParser;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.extendpoint.framework.ISwitchPortName;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;

public class SubInterfaceResIDParser
implements UniResIDParser {
    public static final int iParentNameIndex = 0;
    public static final int iSubIfNumIndex = 1;
    public static final String TYPE = "SUBIF";
    private InterfaceUniResIDParser lpUniResParser;
    private PortUniResIDParser ppUniResParser;
    private int subIfNum;
    private int devID;
    private int vrID;

    public SubInterfaceResIDParser() {
    }

    public SubInterfaceResIDParser(int devID, int vrID, String ifName) {
        this.devID = devID;
        this.vrID = vrID;
        String position = FDNUtil.getPostionFromIfName(ifName);
        String parentifName = ifName.split("\\.")[0];
        int subifNumber = Integer.parseInt(ifName.split("\\.")[1]);
        int parentType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName(parentifName);
        if (U2KInterfaceTypeMapping.getPhysicalInterfaceType().contains(parentType)) {
            this.ppUniResParser = new PortUniResIDParser(devID, parentifName);
        } else if ("" == position) {
            this.lpUniResParser = new InterfaceUniResIDParser(devID, vrID, parentifName);
        } else {
            this.ppUniResParser = new PortUniResIDParser(devID, parentifName, true);
        }
        this.subIfNum = subifNumber;
    }

    public SubInterfaceResIDParser(int devID, int vrID, String parentIfName, int subIfNum) {
        this.lpUniResParser = new InterfaceUniResIDParser(devID, vrID, parentIfName);
        this.subIfNum = subIfNum;
    }

    public SubInterfaceResIDParser(int devID, String position, String parentIfName, int subIfNum) {
        this.ppUniResParser = new PortUniResIDParser(devID, position, parentIfName);
        this.subIfNum = subIfNum;
    }

    public static void main(String[] args) {
        String fdn = "NE=315678,FR=2,S=3,CP=4,SS=5,SC=6,PP=||1|GE 1/0/1,SUBIF=1";
        SubInterfaceResIDParser parser = new SubInterfaceResIDParser();
        parser.deserialize(fdn);
        System.err.println(parser.getSubIfNum());
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        if (fdn == null) {
            throw new UIDParseException("can't deserialize null fdn.");
        }
        StrUIDParser parser = new StrUIDParser();
        if (!parser.parse(fdn)) {
            throw new UIDParseException(String.format("StrUIDParser.parse(%s) fail.", fdn));
        }
        this.decode(parser, fdn.contains("PP"));
        return null;
    }

    public InterfaceUniResIDParser getLpUniResParser() {
        return this.lpUniResParser;
    }

    public PortUniResIDParser getPpUniResParser() {
        return this.ppUniResParser;
    }

    public int getSubIfNum() {
        return this.subIfNum;
    }

    @Override
    public String serialize() throws UIDParseException {
        return this.weave().getStr();
    }

    public void setLpUniResParser(InterfaceUniResIDParser lpUniResParser) {
        this.lpUniResParser = lpUniResParser;
    }

    public void setPpUniResParser(PortUniResIDParser ppUniResParser) {
        this.ppUniResParser = ppUniResParser;
    }

    public void setSubIfNum(int subIfNum) {
        this.subIfNum = subIfNum;
    }

    void decode(StrUIDParser parser, boolean isPP) {
        if (isPP) {
            this.ppUniResParser = new PortUniResIDParser();
            this.ppUniResParser.decode(parser);
        } else {
            this.lpUniResParser = new InterfaceUniResIDParser();
            this.lpUniResParser.decode(parser);
        }
        parser.setCurToFirst();
        while (parser.next()) {
            if (!TYPE.equals(parser.type())) continue;
            this.subIfNum = (int)parser.intValue();
        }
    }

    StrUIDFactory weave() throws UIDParseException {
        StrUIDFactory factory = null;
        ISwitchPortName portName = (ISwitchPortName)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISwitchPortName.class);
        if (portName != null && (factory = portName.convertToVlanSubPortNameByDomain(this.devID, this.vrID, (long)this.subIfNum)) != null) {
            return factory;
        }
        if (this.ppUniResParser != null) {
            factory = this.ppUniResParser.encode();
        } else if (this.lpUniResParser != null) {
            factory = this.lpUniResParser.encode();
        } else {
            throw new UIDParseException("this sub interface parent is not pp or lp.");
        }
        factory.append(TYPE, (long)this.subIfNum);
        return factory;
    }
}

