/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.CardUniResIDParser;

public class SubCardUniResIDParser
extends AbstractUniResIDParser {
    public static final String TYPE = "SC";
    private CardUniResIDParser parent;
    private int subCardID;
    private int subSlotID;

    public SubCardUniResIDParser() {
    }

    public SubCardUniResIDParser(int devID, int frameID, int slotID, int subSlotID) {
        this.parent = new CardUniResIDParser(devID, frameID, subSlotID);
        this.subSlotID = subSlotID;
        this.subCardID = -1;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        StrUIDParser parser = new StrUIDParser();
        if (!parser.parse(fdn)) {
            throw new UIDParseException(String.format("StrUIDParser.parse(%s) fail.", fdn));
        }
        this.decode(parser);
        return this;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    public Integer getSubCardID() {
        return this.subCardID;
    }

    public Integer getSubSlotID() {
        return this.subSlotID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory oFactory = new StrUIDFactory();
        this.encode(oFactory);
        return oFactory.getStr();
    }

    public void setSubCardID(Integer subCardID) {
        this.subCardID = subCardID;
    }

    public void setSubSlotID(Integer subSlotID) {
        this.subSlotID = subSlotID;
    }

    void decode(StrUIDParser parser) {
        this.parent.decode(parser);
        this.subSlotID = this.intValue(parser.strValue("SS"), -1);
        this.subCardID = this.intValue(parser.strValue(TYPE), -1);
    }

    void encode(StrUIDFactory factory) {
        this.parent.encode(factory);
        factory.append("SS", (long)this.subSlotID);
        factory.append(TYPE, -1L);
    }
}

