/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.PwUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class SpwUniResIDParser
extends PwUniResIDParser {
    private static final int PEER_IP_INDEX = 4;
    private String peerIp;

    public SpwUniResIDParser() {
    }

    public SpwUniResIDParser(int devID, int vrID, Long pwID, int pwType, Long transmitLabel, Long receiveLabel, String peerIp) {
        super(devID, vrID, pwID, pwType, transmitLabel, receiveLabel);
        this.peerIp = peerIp;
    }

    public String getPeerIp() {
        return this.peerIp;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.getDevID());
        if (0 != this.getVrID()) {
            factory.append("VR", (long)this.getVrID());
        }
        StrLinker linker = new StrLinker();
        AsnUtil.linkFdnFragment(linker, this.getPwID());
        AsnUtil.linkFdnFragment(linker, this.getPwType());
        AsnUtil.linkFdnFragment(linker, this.getTransmitLabel());
        AsnUtil.linkFdnFragment(linker, this.getReceiveLabel());
        AsnUtil.linkFdnFragment(linker, this.getPeerIp());
        linker.append("");
        factory.append(this.getMOType(), linker.getStr());
        return factory.getStr();
    }

    public void setPeerIp(String peerIp) {
        this.peerIp = peerIp;
    }

    @Override
    protected void setPwParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            switch (i) {
                case 0: {
                    this.setPwID(AsnUtil.longValue(spliter.strValue()));
                    break;
                }
                case 1: {
                    this.setPwType(AsnUtil.intValue(spliter.strValue()));
                    break;
                }
                case 2: {
                    this.setTransmitLabel(AsnUtil.longValue(spliter.strValue()));
                    break;
                }
                case 3: {
                    this.setReceiveLabel(AsnUtil.longValue(spliter.strValue()));
                    break;
                }
                case 4: {
                    this.peerIp = spliter.strValue();
                    break;
                }
            }
            ++i;
        }
    }
}

