/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class SlotUniResIDParser
extends AbstractUniResIDParser {
    private Integer cardID;
    private int devID;
    private int frameID;
    private int slotID;
    private Integer subSlotID;

    public SlotUniResIDParser() {
    }

    public SlotUniResIDParser(int devID, int frameID, int slotID) {
        this.devID = devID;
        this.frameID = frameID;
        this.slotID = slotID;
    }

    public SlotUniResIDParser(int devID, int frameID, int slotID, Integer cardID, Integer subSlotID) {
        this.devID = devID;
        this.frameID = frameID;
        this.slotID = slotID;
        this.cardID = cardID;
        this.subSlotID = subSlotID;
    }

    @Override
    public Object deserialize(String fdn) {
        StrUIDParser parser = new StrUIDParser();
        if (!parser.parse(fdn)) {
            throw new UIDParseException(String.format("StrUIDParser.parse(%s) fail.", fdn));
        }
        this.devID = this.intValue(parser.strValue("NE"), -1);
        this.frameID = this.intValue(parser.strValue("FR"), -1);
        this.slotID = this.intValue(parser.strValue("S"), -1);
        this.subSlotID = this.intValue(parser.strValue("SS"), -1);
        return null;
    }

    public Integer getCardID() {
        return this.cardID;
    }

    public int getDevID() {
        return this.devID;
    }

    public int getFrameID() {
        return this.frameID;
    }

    @Override
    public String getMOType() {
        return "SS";
    }

    public int getSlotID() {
        return this.slotID;
    }

    public Integer getSubSlotID() {
        return this.subSlotID;
    }

    @Override
    public String serialize() {
        StrUIDFactory oFactory = new StrUIDFactory();
        oFactory.append("NE", (long)this.devID).append("FR", (long)this.frameID).append("S", (long)this.slotID);
        if (this.cardID != null) {
            oFactory.append("CP", -1L).append("SS", (long)this.subSlotID.intValue());
        }
        return oFactory.getStr();
    }

    public void setCardID(Integer cardID) {
        this.cardID = cardID;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setFrameID(int frameID) {
        this.frameID = frameID;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public void setSubSlotID(Integer subSlotID) {
        this.subSlotID = subSlotID;
    }
}

