/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.UniResIDParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialResIDParser
implements UniResIDParser {
    public static final int iChannelIndex = 3;
    public static final int iMainNameIndex = 0;
    public static final int iVC12Index = 2;
    public static final int iVC4Index = 1;
    public static final String TYPE_CHANNEL = "CHANNELSET";
    public static final String TYPE_VC12 = "VC12";
    public static final String TYPE_VC4 = "VC4";
    private Integer iChannelSet = null;
    private Integer iVc12 = null;
    private Integer iVc4 = null;
    private Logger logger = LoggerFactory.getLogger(SerialResIDParser.class);
    private PortUniResIDParser ppUniResParser;

    public SerialResIDParser() {
    }

    public SerialResIDParser(int devID, String ifName) {
        String[] ifNames = ifName.split(":");
        String mainName = ifNames[0];
        if (2 == ifNames.length) {
            this.iVc4 = Integer.parseInt(ifNames[1]);
        } else if (3 == ifNames.length) {
            this.iVc4 = Integer.parseInt(ifNames[1]);
            this.iVc12 = Integer.parseInt(ifNames[2]);
        } else if (4 == ifNames.length) {
            this.iVc4 = Integer.parseInt(ifNames[1]);
            this.iVc12 = Integer.parseInt(ifNames[2]);
            this.iChannelSet = Integer.parseInt(ifNames[3]);
        } else {
            this.logger.debug("SerialResIDParser fail:" + ifName);
        }
        this.ppUniResParser = new PortUniResIDParser(devID, mainName);
        this.ppUniResParser.setPortType(null);
        this.ppUniResParser.setCliName(null);
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        if (null == fdn || "".equals(fdn)) {
            throw new UIDParseException("can't deserialize null fdn.");
        }
        StrUIDParser parser = new StrUIDParser();
        if (!parser.parse(fdn)) {
            throw new UIDParseException(String.format("StrUIDParser.parse(%s) fail.", fdn));
        }
        this.decode(parser, fdn.contains("PP"));
        return null;
    }

    public Integer getiChannelSet() {
        return this.iChannelSet;
    }

    public Integer getiVc12() {
        return this.iVc12;
    }

    public Integer getiVc4() {
        return this.iVc4;
    }

    public PortUniResIDParser getPpUniResParser() {
        return this.ppUniResParser;
    }

    @Override
    public String serialize() throws UIDParseException {
        return this.weave().getStr();
    }

    public void setiChannelSet(Integer iChannelSet) {
        this.iChannelSet = iChannelSet;
    }

    public void setiVc12(Integer iVc12) {
        this.iVc12 = iVc12;
    }

    public void setiVc4(Integer iVc4) {
        this.iVc4 = iVc4;
    }

    public void setPpUniResParser(PortUniResIDParser ppUniResParser) {
        this.ppUniResParser = ppUniResParser;
    }

    void decode(StrUIDParser parser, boolean isPP) {
        if (isPP) {
            this.ppUniResParser = new PortUniResIDParser();
            this.ppUniResParser.decode(parser);
        }
        parser.setCurToFirst();
        while (parser.next()) {
            if (TYPE_VC4.equalsIgnoreCase(parser.type())) {
                this.iVc4 = (int)parser.intValue();
                continue;
            }
            if (TYPE_VC12.equalsIgnoreCase(parser.type())) {
                this.iVc12 = (int)parser.intValue();
                continue;
            }
            if (!TYPE_CHANNEL.equalsIgnoreCase(parser.type())) continue;
            this.iChannelSet = (int)parser.intValue();
        }
    }

    StrUIDFactory weave() throws UIDParseException {
        StrUIDFactory factory = null;
        if (this.ppUniResParser == null) {
            throw new UIDParseException("this interface parent is not pp by SerialResIDParser.");
        }
        factory = this.ppUniResParser.encode();
        if (null != this.iVc4) {
            factory.append(TYPE_VC4, (long)this.iVc4.intValue());
        }
        if (null != this.iVc12) {
            factory.append(TYPE_VC12, (long)this.iVc12.intValue());
        }
        if (null != this.iChannelSet) {
            factory.append(TYPE_CHANNEL, (long)this.iChannelSet.intValue());
        }
        return factory;
    }
}

