/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class RsvpTeTunnelUniResIDParser
extends AbstractUniResIDParser {
    public static final String MOC_TYPE = "TUNNEL";
    private int devID;
    private String egressLSRId;
    private String ingressLSRId;
    private Integer position;
    private String signalProtocol;
    private Integer tunnelID;
    private String tunnelName;
    private int vrID;

    public RsvpTeTunnelUniResIDParser() {
    }

    public RsvpTeTunnelUniResIDParser(int devID, String egressLSRId, String ingressLSRId, int position, String signalProtocol, Integer tunnelID, String tunnelName, int vrID) {
        this.devID = devID;
        this.egressLSRId = egressLSRId;
        this.ingressLSRId = ingressLSRId;
        this.position = position;
        this.signalProtocol = signalProtocol;
        this.tunnelID = tunnelID;
        this.tunnelName = tunnelName;
        this.vrID = vrID;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
        StrUIDParser parser = this.parseFdn(fdn, MOC_TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(MOC_TYPE));
        if (spliter.next()) {
            this.signalProtocol = spliter.strValue();
        }
        if (spliter.next()) {
            this.ingressLSRId = spliter.strValue();
        }
        if (spliter.next()) {
            this.egressLSRId = spliter.strValue();
        }
        if (spliter.next()) {
            this.tunnelID = this.intValue(spliter, -1);
        }
        if (spliter.next()) {
            this.tunnelName = spliter.strValue();
        }
        if (spliter.next()) {
            this.position = this.intValue(spliter, -1);
        }
        return this;
    }

    public int getDevID() {
        return this.devID;
    }

    public String getEgressLSRId() {
        return this.egressLSRId;
    }

    public String getIngressLSRId() {
        return this.ingressLSRId;
    }

    @Override
    public String getMOType() {
        return MOC_TYPE;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getSignalProtocol() {
        return this.signalProtocol;
    }

    public Integer getTunnelID() {
        return this.tunnelID;
    }

    public String getTunnelName() {
        return this.tunnelName;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        factory.append("VR", (long)this.vrID);
        StrLinker linker = new StrLinker();
        linker.append(MOC_TYPE);
        linker.append(this.signalProtocol);
        linker.append(this.ingressLSRId == null ? "" : this.ingressLSRId);
        linker.append(this.egressLSRId == null ? "" : this.egressLSRId);
        linker.append(this.tunnelID == null ? "" : String.valueOf(this.tunnelID));
        linker.append(this.tunnelName);
        linker.append(this.position == null ? "" : String.valueOf(this.position));
        factory.append(MOC_TYPE, linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setEgressLSRId(String egressLSRId) {
        this.egressLSRId = egressLSRId;
    }

    public void setIngressLSRId(String ingressLSRId) {
        this.ingressLSRId = ingressLSRId;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public void setSignalProtocol(String signalProtocol) {
        this.signalProtocol = signalProtocol;
    }

    public void setTunnelID(Integer tunnelID) {
        this.tunnelID = tunnelID;
    }

    public void setTunnelName(String tunnelName) {
        this.tunnelName = tunnelName;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }
}

