/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class RmepUniResIDParser
extends AbstractUniResIDParser {
    private static String SPLIT_FLAG = "|";
    private static int ZERO = 0;
    private int iDevID;
    private String strMaName;
    private String strMdName;
    private String strRmepID;

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, this.getMOType());
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setMdName(this.removeSplit(parser.strValue("MD")));
        this.setMaName(this.removeSplit(parser.strValue("MA")));
        this.setRmepID(this.removeSplit(parser.strValue("RMEP")));
        return null;
    }

    public int getDevID() {
        return this.iDevID;
    }

    public String getMaName() {
        return this.strMaName;
    }

    public String getMdName() {
        return this.strMdName;
    }

    @Override
    public String getMOType() {
        return "RMEP";
    }

    public String getRmepID() {
        return this.strRmepID;
    }

    public String removeSplit(String strInfo) {
        if (null == strInfo) {
            return null;
        }
        int fristSplit = strInfo.indexOf(SPLIT_FLAG);
        if (ZERO == fristSplit) {
            return strInfo.substring(fristSplit + 1, strInfo.length());
        }
        return strInfo;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.iDevID);
        StrLinker linkerMd = new StrLinker();
        linkerMd.append("");
        AsnUtil.linkFdnFragment(linkerMd, this.strMdName);
        factory.append("MD", linkerMd.getStr());
        StrLinker linkerMa = new StrLinker();
        linkerMa.append("");
        AsnUtil.linkFdnFragment(linkerMa, this.strMaName);
        factory.append("MA", linkerMa.getStr());
        StrLinker linkerMep = new StrLinker();
        linkerMep.append("");
        AsnUtil.linkFdnFragment(linkerMep, this.strRmepID);
        factory.append("RMEP", linkerMep.getStr());
        return factory.getStr();
    }

    public void setDevID(int iDevID) {
        this.iDevID = iDevID;
    }

    public void setMaName(String strMaName) {
        this.strMaName = strMaName;
    }

    public void setMdName(String strMdName) {
        this.strMdName = strMdName;
    }

    public void setRmepID(String strRmepID) {
        this.strRmepID = strRmepID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }
}

