/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class RingUniResIDParser
extends AbstractUniResIDParser {
    private static final int RING_ID_INDEX = 0;
    private int devID;
    private int ringID;

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        StrLinker linker = new StrLinker();
        AsnUtil.linkFdnFragment(linker, this.ringID);
        factory.append(this.getMOType(), linker.getStr());
        return factory.getStr();
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, this.getMOType());
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        StrSpliter spliter = this.parseFragment(parser.strValue(this.getMOType()));
        this.setRingParas(spliter);
        return null;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    private void setRingParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            if (0 == i) {
                this.ringID = AsnUtil.intValue(spliter.strValue());
            }
            ++i;
        }
    }

    @Override
    public String getMOType() {
        return "RING";
    }

    public int getDevID() {
        return this.devID;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public int getRingID() {
        return this.ringID;
    }

    public void setRingID(int ringID) {
        this.ringID = ringID;
    }
}

