/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class RingMapVirtualNodeUniResIDParser
extends AbstractUniResIDParser {
    public static final String MOC_TYPE = "VIRTUALNODE";
    private static final int RING_ID_INDEX = 0;
    private int devID;
    private int ringId;
    private int virtualNodeId;
    private int vrID;

    public RingMapVirtualNodeUniResIDParser() {
    }

    public RingMapVirtualNodeUniResIDParser(int devID, int vrID, int ringId, int virtualNodeId) {
        this.devID = devID;
        this.vrID = vrID;
        this.ringId = ringId;
        this.virtualNodeId = virtualNodeId;
    }

    @Override
    public Object deserialize(String fdn) {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, MOC_TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(MOC_TYPE));
        this.setParas(spliter);
        return null;
    }

    private void setParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            String str = spliter.strValue();
            int value = Integer.valueOf(str);
            if (0 == i) {
                this.ringId = value;
            } else {
                this.virtualNodeId = value;
            }
            ++i;
        }
    }

    @Override
    public String getMOType() {
        return MOC_TYPE;
    }

    @Override
    public String serialize() {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID && -1 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append((long)this.ringId);
        linker.append((long)this.virtualNodeId);
        factory.append(MOC_TYPE, linker.getStr());
        return factory.getStr();
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    public int getDevID() {
        return this.devID;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public int getRingId() {
        return this.ringId;
    }

    public void setRingId(int ringId) {
        this.ringId = ringId;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    public int getVrID() {
        return this.vrID;
    }

    public int getVirtualNodeId() {
        return this.virtualNodeId;
    }

    public void setVirtualNodeId(int virtualNodeId) {
        this.virtualNodeId = virtualNodeId;
    }
}

