/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class PwswUniResIDParser
extends AbstractUniResIDParser {
    private static final int PW_SWITCH_ID_INDEX = 0;
    private static final int LEFT_PEER_IP_INDEX = 2;
    private static final int LEFT_PW_ID_INDEX = 1;
    private static final int LEFT_RECEI_LABEL_INDEX = 4;
    private static final int LEFT_TRANSMIT_LABEL_INDEX = 3;
    private static final int PW_TYPE_INDEX = 9;
    private static final int RIGHT_PEER_IP_INDEX = 6;
    private static final int RIGHT_PW_ID_INDEX = 5;
    private static final int RIGHT_RECEI_LABEL_INDEX = 8;
    private static final int RIGHT_TRANSMIT_LABEL_INDEX = 7;
    private int devID;
    private String pwSwitchID;
    private String leftPeerIP;
    private Long leftPwID;
    private Long leftReceiLabel;
    private Long leftTransmitLabel;
    private int pwType;
    private String rightPeerIP;
    private Long rightPwID;
    private Long rightReceiLabel;
    private Long rightTransmitLabel;
    private int vrID;

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, this.getMOType());
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(this.getMOType()));
        this.setPwswParas(spliter);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    public String getLeftPeerIP() {
        return this.leftPeerIP;
    }

    public Long getLeftPwID() {
        return this.leftPwID;
    }

    public Long getLeftReceiLabel() {
        return this.leftReceiLabel;
    }

    public Long getLeftTransmitLabel() {
        return this.leftTransmitLabel;
    }

    @Override
    public String getMOType() {
        return "PWSW";
    }

    public int getPwType() {
        return this.pwType;
    }

    public String getRightPeerIP() {
        return this.rightPeerIP;
    }

    public Long getRightPwID() {
        return this.rightPwID;
    }

    public Long getRightReceiLabel() {
        return this.rightReceiLabel;
    }

    public Long getRightTransmitLabel() {
        return this.rightTransmitLabel;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        AsnUtil.linkFdnFragment(linker, this.pwSwitchID);
        AsnUtil.linkFdnFragment(linker, this.leftPwID);
        AsnUtil.linkFdnFragment(linker, this.leftPeerIP);
        AsnUtil.linkFdnFragment(linker, this.leftTransmitLabel);
        AsnUtil.linkFdnFragment(linker, this.leftReceiLabel);
        AsnUtil.linkFdnFragment(linker, this.rightPwID);
        AsnUtil.linkFdnFragment(linker, this.rightPeerIP);
        AsnUtil.linkFdnFragment(linker, this.rightTransmitLabel);
        AsnUtil.linkFdnFragment(linker, this.rightReceiLabel);
        AsnUtil.linkFdnFragment(linker, this.pwType);
        factory.append(this.getMOType(), linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setLeftPeerIP(String leftPeerIP) {
        this.leftPeerIP = leftPeerIP;
    }

    public void setLeftPwID(Long leftPwID) {
        this.leftPwID = leftPwID;
    }

    public void setLeftReceiLabel(Long leftReceiLabel) {
        this.leftReceiLabel = leftReceiLabel;
    }

    public void setLeftTransmitLabel(Long leftTransmitLabel) {
        this.leftTransmitLabel = leftTransmitLabel;
    }

    public void setPwType(int pwType) {
        this.pwType = pwType;
    }

    public void setRightPeerIP(String rightPeerIP) {
        this.rightPeerIP = rightPeerIP;
    }

    public void setRightPwID(Long rightPwID) {
        this.rightPwID = rightPwID;
    }

    public void setRightReceiLabel(Long rightReceiLabel) {
        this.rightReceiLabel = rightReceiLabel;
    }

    public void setRightTransmitLabel(Long rightTransmitLabel) {
        this.rightTransmitLabel = rightTransmitLabel;
    }

    public String getPwSwitchID() {
        return this.pwSwitchID;
    }

    public void setPwSwitchID(String pwSwitchID) {
        this.pwSwitchID = pwSwitchID;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    private void setPwswParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            if (0 == i) {
                this.pwSwitchID = spliter.strValue();
            } else if (1 == i) {
                this.leftPwID = AsnUtil.longValue(spliter.strValue());
            } else if (2 == i) {
                this.leftPeerIP = spliter.strValue();
            } else if (3 == i) {
                this.leftTransmitLabel = AsnUtil.longValue(spliter.strValue());
            } else if (4 == i) {
                this.leftReceiLabel = AsnUtil.longValue(spliter.strValue());
            } else if (5 == i) {
                this.rightPwID = AsnUtil.longValue(spliter.strValue());
            } else if (6 == i) {
                this.rightPeerIP = spliter.strValue();
            } else if (7 == i) {
                this.rightTransmitLabel = AsnUtil.longValue(spliter.strValue());
            } else if (8 == i) {
                this.rightReceiLabel = AsnUtil.longValue(spliter.strValue());
            } else if (9 == i) {
                this.pwType = AsnUtil.intValue(spliter.strValue());
            }
            ++i;
        }
    }
}

