/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class Pwe3UniResIDParser
extends AbstractUniResIDParser {
    private static final int INTERFACE_NAME_INDEX = 2;
    private static final int IF_ID_INDEX = 1;
    private static final int SERVICE_TYPE_INDEX = 0;
    private int devID;
    private String ifID;
    private String interfaceName;
    private Integer serviceType;
    private int vrID;

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, this.getMOType());
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(this.getMOType()));
        this.setPwe3Paras(spliter);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Override
    public String getMOType() {
        return "PWE3";
    }

    public Integer getServiceType() {
        return this.serviceType;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        AsnUtil.linkFdnFragment(linker, this.serviceType);
        AsnUtil.linkFdnFragment(linker, this.ifID);
        AsnUtil.linkFdnFragment(linker, this.interfaceName);
        factory.append(this.getMOType(), linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getIfID() {
        return this.ifID;
    }

    public void setIfID(String ifID) {
        this.ifID = ifID;
    }

    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    private void setPwe3Paras(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            if (0 == i) {
                this.serviceType = AsnUtil.intValue(spliter.strValue());
            } else if (1 == i) {
                this.ifID = spliter.strValue();
            } else if (2 == i) {
                this.interfaceName = spliter.strValue();
            }
            ++i;
        }
    }
}

