/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class PwUniResIDParser
extends AbstractUniResIDParser {
    protected static final int PW_ID_INDEX = 0;
    protected static final int PW_TYPE_INDEX = 1;
    protected static final int RECEIVE_LABEL_INDEX = 3;
    protected static final int TRANSMIT_LABEL_INDEX = 2;
    protected static final int PEERIP_INDEX = 4;
    protected static final int VSINAME_INDEX = 5;
    private int devID;
    private Long pwID;
    private int pwType;
    private Long receiveLabel;
    private Long transmitLabel;
    private int vrID;
    private String peerIP;
    private String VSIName;

    public PwUniResIDParser() {
    }

    public PwUniResIDParser(int devID, int vrID, Long pwID, int pwType, Long transmitLabel, Long receiveLabel) {
        this.devID = devID;
        this.vrID = vrID;
        this.pwID = pwID;
        this.pwType = pwType;
        this.transmitLabel = transmitLabel;
        this.receiveLabel = receiveLabel;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, this.getMOType());
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(this.getMOType()));
        this.setPwParas(spliter);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return "PW";
    }

    public Long getPwID() {
        return this.pwID;
    }

    public int getPwType() {
        return this.pwType;
    }

    public Long getReceiveLabel() {
        return this.receiveLabel;
    }

    public Long getTransmitLabel() {
        return this.transmitLabel;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        AsnUtil.linkFdnFragment(linker, this.pwID);
        AsnUtil.linkFdnFragment(linker, this.pwType);
        AsnUtil.linkFdnFragment(linker, this.transmitLabel);
        AsnUtil.linkFdnFragment(linker, this.receiveLabel);
        linker.append("");
        linker.append("");
        factory.append(this.getMOType(), linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setPwID(Long pwID) {
        this.pwID = pwID;
    }

    public void setPwType(int pwType) {
        this.pwType = pwType;
    }

    public void setReceiveLabel(Long receiveLabel) {
        this.receiveLabel = receiveLabel;
    }

    public void setTransmitLabel(Long transmitLabel) {
        this.transmitLabel = transmitLabel;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    public String getPeerIP() {
        return this.peerIP;
    }

    public void setPeerIP(String peerIP) {
        this.peerIP = peerIP;
    }

    public String getVSIName() {
        return this.VSIName;
    }

    public void setVSIName(String vSIName) {
        this.VSIName = vSIName;
    }

    protected void setPwParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            switch (i) {
                case 0: {
                    this.pwID = AsnUtil.longValue(spliter.strValue());
                    break;
                }
                case 1: {
                    this.pwType = AsnUtil.intValue(spliter.strValue());
                    break;
                }
                case 2: {
                    this.transmitLabel = AsnUtil.longValue(spliter.strValue());
                    break;
                }
                case 3: {
                    this.receiveLabel = AsnUtil.longValue(spliter.strValue());
                    break;
                }
                case 4: {
                    this.peerIP = spliter.strValue();
                    break;
                }
                case 5: {
                    this.VSIName = spliter.strValue();
                    break;
                }
            }
            ++i;
        }
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }
}

