/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class PtnQosProfileUniResIDParser
extends AbstractUniResIDParser {
    public static final String MOC_TYPE = "QOS";
    private static final int POLICY_ID_INDEX = 1;
    private static final int POLICY_NAME_INDEX = 2;
    private int devID;
    private int vrID;
    private int plcyID;
    private String plcyName;

    public PtnQosProfileUniResIDParser() {
    }

    public PtnQosProfileUniResIDParser(int devID, int vrID, String plcyName, int plcyID) {
        this.devID = devID;
        this.vrID = vrID;
        this.plcyName = plcyName;
        this.plcyID = plcyID;
    }

    @Override
    public Object deserialize(String fdn) {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, MOC_TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(MOC_TYPE));
        this.setPlcyParas(spliter);
        return null;
    }

    private void setPlcyParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            if (1 == i) {
                this.plcyID = this.intValue(spliter.strValue(), -1);
            } else if (2 == i) {
                this.plcyName = spliter.strValue();
            }
            ++i;
        }
    }

    @Override
    public String serialize() {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID && -1 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append((long)this.plcyID);
        linker.append(this.plcyName);
        factory.append(MOC_TYPE, linker.getStr());
        return factory.getStr();
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    public void setPlcyName(String plcyName) {
        this.plcyName = plcyName;
    }

    public String getPlcyName() {
        return this.plcyName;
    }

    public void setPlcyID(int plcyID) {
        this.plcyID = plcyID;
    }

    public int getPlcyID() {
        return this.plcyID;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    public int getVrID() {
        return this.vrID;
    }

    public int getDevID() {
        return this.devID;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    @Override
    public String getMOType() {
        return MOC_TYPE;
    }
}

