/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class ProtectionGroupUniResIDParser
extends AbstractUniResIDParser {
    public static final String MOC_TYPE = "TPG";
    private int devID;
    private String protectionGroupName;
    private int vrID;

    public ProtectionGroupUniResIDParser() {
    }

    public ProtectionGroupUniResIDParser(int devID, int vrID, String protectionGroupName) {
        this.devID = devID;
        this.vrID = vrID;
        this.protectionGroupName = protectionGroupName;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, MOC_TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(MOC_TYPE));
        if (spliter.next()) {
            this.setProtectionGroupName(spliter.strValue());
        }
        return this;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return MOC_TYPE;
    }

    public String getProtectionGroupName() {
        return this.protectionGroupName;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        factory.append("VR", (long)this.vrID);
        StrLinker linker = new StrLinker();
        linker.append(this.protectionGroupName == null ? "" : this.protectionGroupName);
        factory.append(MOC_TYPE, linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setProtectionGroupName(String protectionGroupName) {
        this.protectionGroupName = protectionGroupName;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }
}

