/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.PhysicalEntityResIDParser;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.extendpoint.framework.ISwitchPortName;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PortUniResIDParser
extends PhysicalEntityResIDParser {
    public static final int CHASSIS_ID = 0;
    public static final int PORT_ID = 3;
    public static final int SLOT_ID = 1;
    public static final int SUBSLOT_ID = 2;
    public static final String TYPE = "PP";
    private static final Logger logger = LoggerFactory.getLogger(PortUniResIDParser.class);
    private int boardID;
    private String cliName;
    private int devID;
    private int frameID;
    private String MOC_TYPE = "PP";
    private Integer portDomain;
    private int portID;
    private Integer portType;
    private int slotID;
    private Integer subCardID;
    private Integer subSlotID;

    public PortUniResIDParser() {
        this(-1, -1, -1, -1, null);
    }

    public PortUniResIDParser(int devID, int frameID, int slotID, int boardID, Integer subSlotID, Integer subCardID, int portID, Integer portDomain, Integer portType, String cliName) {
        this.devID = devID;
        this.frameID = frameID;
        this.slotID = slotID;
        this.boardID = boardID;
        this.subSlotID = subSlotID;
        this.subCardID = subCardID;
        this.portID = portID;
        this.portDomain = portDomain;
        this.portType = portType;
        this.cliName = cliName;
    }

    public PortUniResIDParser(int devID, int frameID, int slotID, int portID, String cliName) {
        this(devID, frameID, slotID, -1, null, null, portID, null, U2KInterfaceTypeMapping.getInterfaceTypeFromIfName(cliName), cliName);
    }

    public PortUniResIDParser(int devID, int frameID, int slotID, Integer subSlotID, int portID, String cliName) {
        this(devID, frameID, slotID, -1, subSlotID, -1, portID, null, U2KInterfaceTypeMapping.getInterfaceTypeFromIfName(cliName), cliName);
    }

    public PortUniResIDParser(int devID, String cliName) {
        this(devID, FDNUtil.getPostionFromIfName(cliName), cliName);
    }

    public PortUniResIDParser(int devID, String cliName, boolean isLP) {
        this(devID, FDNUtil.getPostionFromIfName(cliName), cliName);
        if (isLP) {
            this.MOC_TYPE = "LP";
        }
    }

    public PortUniResIDParser(int devID, String position, String cliName) {
        Assert.hasText((String)cliName, (String)String.format("ifName=[%s] is illegal.", cliName));
        if (position != null && !"".equals(position)) {
            this.setPostion(position);
        } else {
            this.setPostion(FDNUtil.getPostionFromIfName(cliName));
        }
        this.devID = devID;
        this.cliName = cliName;
        this.portType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName(cliName);
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        StrUIDParser parser = new StrUIDParser();
        if (!parser.parse(fdn)) {
            throw new UIDParseException(String.format("StrUIDParser.parse(%s) fail.", fdn));
        }
        if (!this.MOC_TYPE.equals(parser.getMOC())) {
            throw new UIDParseException("expect PP, but actual is " + parser.getMOC());
        }
        this.decode(parser);
        return this;
    }

    public int getBoardID() {
        return this.boardID;
    }

    public String getCliName() {
        ISwitchPortName portName = (ISwitchPortName)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISwitchPortName.class);
        if (portName != null) {
            return portName.convertToVrpPortName(this.devID, this.slotID, this.subCardID == null ? 0 : this.subCardID, this.portID);
        }
        return this.cliName;
    }

    public int getDevID() {
        return this.devID;
    }

    public int getFrameID() {
        return this.frameID;
    }

    @Override
    public String getMOType() {
        return this.MOC_TYPE;
    }

    public Integer getPortDomain() {
        return this.portDomain;
    }

    public int getPortID() {
        return this.portID;
    }

    public Integer getPortType() {
        return this.portType;
    }

    @Override
    public final String getPostion() {
        StringBuilder builder = new StringBuilder();
        if (this.frameID <= 0) {
            builder.append(this.slotID);
        } else {
            builder.append(this.frameID);
            builder.append('/');
            builder.append(this.slotID);
        }
        if (this.subSlotID != null && this.subSlotID >= 0) {
            builder.append('/');
            builder.append(this.subSlotID);
        }
        builder.append('/');
        builder.append(this.portID);
        return builder.toString();
    }

    public int getSlotID() {
        return this.slotID;
    }

    public int getSubCardID() {
        return this.subCardID;
    }

    public Integer getSubSlotID() {
        return this.subSlotID;
    }

    @Override
    public String serialize() throws UIDParseException {
        if (this.devID < 0 || this.frameID < 0 || this.portID < 0) {
            throw new UIDParseException("can't serialize to fdn by:" + this.toString());
        }
        return this.encode().getStr();
    }

    public void setBoardID(int boardID) {
        this.boardID = boardID;
    }

    public void setCliName(String cliName) {
        this.cliName = cliName;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setFrameID(int frameID) {
        this.frameID = frameID;
    }

    public void setMocType(String type) {
        this.MOC_TYPE = type;
    }

    public void setPortDomain(Integer portDomain) {
        this.portDomain = portDomain;
    }

    public void setPortID(int portID) {
        this.portID = portID;
    }

    public void setPortType(Integer portType) {
        this.portType = portType;
    }

    @Override
    public final void setPostion(String position) {
        if (position == null) {
            return;
        }
        String[] coordinate = position.split("/");
        if (4 == coordinate.length) {
            this.frameID = Integer.parseInt(coordinate[0]);
            this.slotID = Integer.parseInt(coordinate[1]);
            this.subSlotID = Integer.parseInt(coordinate[2]);
            this.portID = Integer.parseInt(coordinate[3]);
        } else if (3 == coordinate.length) {
            this.slotID = Integer.parseInt(coordinate[0]);
            this.subSlotID = Integer.parseInt(coordinate[1]);
            this.portID = Integer.parseInt(coordinate[2]);
            this.frameID = 1;
        } else {
            logger.error("invalid interface postion:{}", (Object)position);
        }
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public void setSubCardID(int subcardID) {
        this.subCardID = subcardID;
    }

    public void setSubCardID(Integer subCardID) {
        this.subCardID = subCardID;
    }

    public void setSubSlotID(Integer subSlotID) {
        this.subSlotID = subSlotID;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PortUniResIDParser [devID=");
        builder.append(this.devID);
        builder.append(", frameID=");
        builder.append(this.frameID);
        builder.append(", slotID=");
        builder.append(this.slotID);
        builder.append(", boardID=");
        builder.append(this.boardID);
        builder.append(", subSlotID=");
        builder.append(this.subSlotID);
        builder.append(", subcardID=");
        builder.append(this.subCardID);
        builder.append(", portID=");
        builder.append(this.portID);
        builder.append(", portDomain=");
        builder.append(this.portDomain);
        builder.append(", portType=");
        builder.append(this.portType);
        builder.append("]");
        return builder.toString();
    }

    void decode(StrUIDParser parser) {
        while (parser.next()) {
            String type = parser.type();
            this.setEntityIDs(type, parser);
        }
    }

    StrUIDFactory encode() {
        StrUIDFactory factory;
        ISwitchPortName portName = (ISwitchPortName)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISwitchPortName.class);
        if (portName != null && (factory = portName.convertToPortFdnByDomain(this.devID, this.slotID, this.portID)) != null) {
            return factory;
        }
        factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        factory.append("FR", (long)this.frameID);
        if (null != this.cliName) {
            int tmpChar = 32;
            int iPot = this.cliName.indexOf("0/");
            if (iPot > 0 && 47 != (tmpChar = (int)this.cliName.charAt(iPot - 1)) && (tmpChar > 57 || tmpChar < 48)) {
                this.slotID = 0;
            }
        }
        factory.append("S", (long)this.slotID);
        factory.append("CP", -1L);
        if (this.subSlotID != null) {
            factory.append("SS", (long)this.subSlotID.intValue());
            factory.append("SC", -1L);
        }
        StrLinker linker = new StrLinker();
        linker.append(this.portDomain == null ? "" : String.valueOf(this.portDomain));
        linker.append(this.portType == null ? "" : String.valueOf(this.portType));
        linker.append((long)this.portID);
        linker.append(this.cliName == null ? "" : this.cliName);
        factory.append(this.MOC_TYPE, linker.getStr());
        return factory;
    }

    private void setEntityIDs(String type, StrUIDParser parser) {
        if ("NE".equals(type)) {
            this.setDevID((int)parser.intValue());
        } else if ("FR".equals(type)) {
            this.setFrameID((int)parser.intValue());
        } else if ("S".equals(type)) {
            this.setSlotID((int)parser.intValue());
        } else if ("SS".equals(type)) {
            this.setSubSlotID((int)parser.intValue());
        } else if (this.MOC_TYPE.equals(type)) {
            this.setPPInfo(parser);
        }
    }

    private void setPPInfo(StrUIDParser parser) {
        StrSpliter spliter = new StrSpliter();
        String pp = parser.strValue();
        if (!spliter.parse(pp)) {
            return;
        }
        spliter.next();
        spliter.next();
        if (spliter.next()) {
            this.portID = (int)spliter.longValue();
        }
        if (spliter.next()) {
            this.cliName = spliter.strValue();
        }
    }
}

