/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class OspfUniResIDParser
extends AbstractUniResIDParser {
    public static final String TYPE = "OSPF";
    public static final String TYPE_VRF = "VRF";
    private int devID;
    private int processId;
    private int vrID;

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        this.setProcessId(this.intValue(parser.strValue(TYPE), 0));
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        factory.append(TYPE, (long)this.processId);
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }
}

