/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.PhysicalEntityResIDParser;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NEUniResIDParser
extends PhysicalEntityResIDParser {
    public static final String TYPE = "NE";
    private static final Logger logger = LoggerFactory.getLogger(NEUniResIDParser.class);
    private int devID;

    public NEUniResIDParser() {
        this.devID = -1;
    }

    public NEUniResIDParser(int devID) {
        this.devID = devID;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        ToStringBuilder buf = new ToStringBuilder((Object)"deserialize ne fdn");
        buf.append("FDN", (Object)fdn);
        try {
            StrUIDParser parser = new StrUIDParser();
            if (!parser.parse(fdn)) {
                buf.append("RESULT", (Object)"parse fail");
                throw new UIDParseException(buf.toString());
            }
            this.devID = this.intValue(parser.strValue(TYPE), -1);
        }
        catch (Exception e) {
            buf.append("RESULT", (Object)"exception");
            throw new UIDParseException(buf.toString(), e);
        }
        return this;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    @Override
    public final String getPostion() {
        return "0";
    }

    @Override
    public String serialize() throws UIDParseException {
        ToStringBuilder buf = new ToStringBuilder((Object)"serialize ne to fdn");
        buf.append("DEVID", this.devID);
        if (this.devID < 0) {
            buf.append("RESULT", (Object)"illegal");
            throw new UIDParseException(buf.toString());
        }
        StrUIDFactory factory = new StrUIDFactory();
        factory.append(TYPE, (long)this.devID);
        String fdn = factory.getStr();
        buf.append("RESULT", (Object)fdn);
        logger.info(buf.toString());
        return fdn;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    @Override
    public final void setPostion(String position) {
    }
}

