/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class MplsRingUniResIDParser
extends AbstractUniResIDParser {
    public static final String MOC_TYPE = "RING";
    private int devID;
    private int ringId;
    private int vrID;

    public MplsRingUniResIDParser() {
    }

    public MplsRingUniResIDParser(int devID, int vrID, int ringId) {
        this.devID = devID;
        this.vrID = vrID;
        this.ringId = ringId;
    }

    @Override
    public Object deserialize(String fdn) {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, MOC_TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        this.setRingId(this.intValue(parser.strValue(MOC_TYPE), -1));
        return null;
    }

    @Override
    public String getMOType() {
        return MOC_TYPE;
    }

    @Override
    public String serialize() {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID && -1 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        factory.append(MOC_TYPE, (long)this.ringId);
        return factory.getStr();
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    public int getDevID() {
        return this.devID;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public int getRingId() {
        return this.ringId;
    }

    public void setRingId(int ringId) {
        this.ringId = ringId;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    public int getVrID() {
        return this.vrID;
    }
}

