/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class MIPUniResIDParser
extends AbstractUniResIDParser {
    private static int FIRST_SPLIT_POSITION = 0;
    private static String SPLIT_FLAG = "|";
    private static final String TYPE = "MIP";
    private int iDevID;
    private String strIFName;

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, this.getMOType());
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setIFName(this.removeSplit(parser.strValue(TYPE)));
        return null;
    }

    public int getDevID() {
        return this.iDevID;
    }

    public String getIFName() {
        return this.strIFName;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    public String removeSplit(String strInfo) {
        if (null == strInfo) {
            return null;
        }
        int fristSplit = strInfo.indexOf(SPLIT_FLAG);
        if (FIRST_SPLIT_POSITION == fristSplit) {
            return strInfo.substring(fristSplit + 1, strInfo.length());
        }
        return strInfo;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.iDevID);
        StrLinker linkerMd = new StrLinker();
        linkerMd.append("");
        AsnUtil.linkFdnFragment(linkerMd, this.strIFName);
        factory.append(TYPE, linkerMd.getStr());
        return factory.getStr();
    }

    public void setDevID(int iDevID) {
        this.iDevID = iDevID;
    }

    public void setIFName(String strIFName) {
        this.strIFName = strIFName;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }
}

