/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.UniResIDParser;

public class LspUniResIDParser
implements UniResIDParser {
    private int devID;
    private String inLsrID;
    private Integer lspID;
    private String outLsrID;
    private Integer sessionID;
    private int vrID;

    public LspUniResIDParser() {
    }

    public LspUniResIDParser(String inLsrID, String outLsrID, Integer lspID, Integer sessionID, int devID, int vrID) {
        this.inLsrID = inLsrID;
        this.outLsrID = outLsrID;
        this.lspID = lspID;
        this.sessionID = sessionID;
    }

    @Override
    public Object deserialize(String fdn) {
        StrUIDParser parser = new StrUIDParser();
        if (!parser.parse(fdn)) {
            return null;
        }
        while (parser.next()) {
            String type = parser.type();
            if ("NE".equals(type)) {
                this.setDevID((int)parser.intValue());
                continue;
            }
            if ("VR".equals(type)) {
                this.setVrID((int)parser.intValue());
                continue;
            }
            if (!"LSP".equals(type)) continue;
            StrSpliter spliter = new StrSpliter();
            String logicIf = parser.strValue();
            if (!spliter.parse(logicIf)) {
                return null;
            }
            this.deserializeLspFiled(spliter);
        }
        return null;
    }

    @Override
    public String serialize() {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append(this.inLsrID).append((long)this.sessionID.intValue()).append((long)this.lspID.intValue());
        factory.append("LSP", linker.getStr());
        return factory.getStr();
    }

    protected int getDevID() {
        return this.devID;
    }

    protected String getInLsrID() {
        return this.inLsrID;
    }

    protected Integer getLspID() {
        return this.lspID;
    }

    protected String getOutLsrID() {
        return this.outLsrID;
    }

    protected Integer getSessionID() {
        return this.sessionID;
    }

    protected int getVrID() {
        return this.vrID;
    }

    protected void setDevID(int devID) {
        this.devID = devID;
    }

    protected void setInLsrID(String inLsrID) {
        this.inLsrID = inLsrID;
    }

    protected void setLspID(Integer lspID) {
        this.lspID = lspID;
    }

    protected void setOutLsrID(String outLsrID) {
        this.outLsrID = outLsrID;
    }

    protected void setSessionID(Integer sessionID) {
        this.sessionID = sessionID;
    }

    protected void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void deserializeLspFiled(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            switch (i) {
                case 0: {
                    this.inLsrID = spliter.strValue();
                    break;
                }
                case 1: {
                    this.sessionID = (int)spliter.longValue();
                    break;
                }
                case 2: {
                    this.lspID = (int)spliter.longValue();
                    break;
                }
            }
            ++i;
        }
    }
}

