/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class LdpSessionUniResIDParser
extends AbstractUniResIDParser {
    public static final String TYPE = "LDPSESSION";
    private int devID;
    private String egressLsrID;
    private String ingressLsrID;
    private int vrID;

    public LdpSessionUniResIDParser() {
    }

    public LdpSessionUniResIDParser(int devID, int vrID, String ingressLsrID, String egressLsrID) {
        this.devID = devID;
        this.vrID = vrID;
        this.ingressLsrID = ingressLsrID;
        this.egressLsrID = egressLsrID;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        StrUIDParser parser = this.parseFdn(fdn, TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(TYPE));
        if (spliter.next()) {
            this.setEgressLsrID(spliter.strValue());
        }
        if (spliter.next()) {
            this.setIngressLsrID(spliter.strValue());
        }
        return this;
    }

    public int getDevID() {
        return this.devID;
    }

    public String getEgressLsrID() {
        return this.egressLsrID;
    }

    public String getIngressLsrID() {
        return this.ingressLsrID;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append(this.egressLsrID).append(this.ingressLsrID);
        factory.append(TYPE, linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setEgressLsrID(String egressLsrID) {
        this.egressLsrID = egressLsrID;
    }

    public void setIngressLsrID(String ingressLsrID) {
        this.ingressLsrID = ingressLsrID;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LdpSessionUniResIDParser [devID=");
        builder.append(this.devID);
        builder.append(", vrID=");
        builder.append(this.vrID);
        builder.append(", ingressLsrID=");
        builder.append(this.ingressLsrID);
        builder.append(", egressLsrID=");
        builder.append(this.egressLsrID);
        builder.append("]");
        return builder.toString();
    }
}

