/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class LdpLspUniResIDParser
extends AbstractUniResIDParser {
    public static final String MOC_TYPE = "TUNNEL";
    private static final int LSP_ADDR_INDEX = 3;
    private int devID;
    private String lspAddr;
    private int vrID;

    public LdpLspUniResIDParser() {
    }

    public LdpLspUniResIDParser(int devID, int vrID, String lspAddr) {
        this.devID = devID;
        this.vrID = vrID;
        this.lspAddr = lspAddr;
    }

    @Override
    public Object deserialize(String fdn) {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, MOC_TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(MOC_TYPE));
        this.setTnlParas(spliter);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    public String getLspAddr() {
        return this.lspAddr;
    }

    @Override
    public String getMOType() {
        return MOC_TYPE;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID && -1 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        StrLinker linker = new StrLinker();
        linker.append(1L);
        linker.append("");
        linker.append("");
        linker.append(this.lspAddr);
        linker.append("");
        linker.append("");
        linker.append("");
        factory.append(MOC_TYPE, linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setLspAddr(String lspAddr) {
        this.lspAddr = lspAddr;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    private void setTnlParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            if (3 == i) {
                this.lspAddr = spliter.strValue();
            }
            ++i;
        }
    }
}

