/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;

public class LagUniResIDParser
extends AbstractUniResIDParser {
    public static final String TYPE = "LP";
    private int devID;
    private Integer portDomain;
    private int portID;
    private Integer portType;
    private int PTNDOMAIN = 16;

    public LagUniResIDParser() {
    }

    public LagUniResIDParser(int devID, Integer type, int portID) {
        this.devID = devID;
        this.portType = type;
        this.portID = portID;
    }

    @Override
    public Object deserialize(String fdn) {
        StrUIDParser parser = this.parseFdn(fdn, TYPE);
        this.decode(parser);
        return this;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    public Integer getPortDomain() {
        return this.portDomain;
    }

    public long getPortID() {
        return this.portID;
    }

    public Integer getPortType() {
        return this.portType;
    }

    @Override
    public String serialize() {
        return this.encode().getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setPortDomain(Integer portDomain) {
        this.portDomain = portDomain;
    }

    public void setPortID(int portID) {
        this.portID = portID;
    }

    public void setPortType(Integer portType) {
        this.portType = portType;
    }

    void decode(StrUIDParser parser) {
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        StrSpliter spliter = this.parseFragment(parser.strValue(TYPE));
        if (spliter.next()) {
            this.portDomain = this.intValue(spliter, -1);
        }
        if (spliter.next()) {
            this.portType = this.intValue(spliter, -1);
        }
        if (spliter.next()) {
            this.portID = this.intValue(spliter, -1);
        }
        spliter.next();
    }

    StrUIDFactory encode() {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        StrLinker linker = new StrLinker();
        if (null != this.portDomain) {
            linker.append((long)this.portDomain.intValue());
        } else {
            linker.append((long)this.PTNDOMAIN);
        }
        if (null != this.portType) {
            linker.append((long)this.portType.intValue());
        } else {
            linker.append(65539L);
        }
        linker.append((long)this.portID).append("");
        factory.append(TYPE, linker.getStr());
        return factory;
    }
}

