/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import org.springframework.util.StringUtils;

public class L3vpnUniResIDParser
extends AbstractUniResIDParser {
    public static final String TYPE = "VRF";
    private static final int VRF_ID_INDEX = 0;
    private static final int VRF_NAME_INDEX = 1;
    private int devID;
    private String vrfID;
    private String vrfName;
    private int vrID;

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = new StrSpliter();
        spliter.parse(parser.strValue(TYPE));
        int i = 0;
        while (spliter.next()) {
            String str;
            if (0 == i && StringUtils.hasText((String)(str = spliter.strValue()))) {
                this.setVrfID(spliter.strValue());
            }
            if (1 == i && StringUtils.hasText((String)(str = spliter.strValue()))) {
                this.setVrfName(spliter.strValue());
            }
            ++i;
        }
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    public String getVrfID() {
        return this.vrfID;
    }

    public String getVrfName() {
        return this.vrfName;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        if (null == this.vrfID) {
            this.vrfID = "";
        }
        if (null == this.vrfName) {
            this.vrfName = "";
        }
        factory.append(TYPE, this.vrfID + '|' + this.vrfName);
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setVrfID(String string) {
        this.vrfID = string;
    }

    public void setVrfName(String vrfName) {
        this.vrfName = vrfName;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }
}

