/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.AbstractUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;

public class L3vpnStaticFrrUniResIDParser
extends AbstractUniResIDParser {
    public static final String TYPE = "FRR";
    private static final int INDEX0_FRRID = 0;
    private static final int INDEX1_MASTERHOP = 1;
    private static final int INDEX2_SLAVEHOP = 2;
    private static final int INDEX3_MASTERIF = 3;
    private static final int INDEX4_SLAVEIF = 4;
    private int devID;
    private String frrName;
    private String ifNameMaster;
    private String ifNameSlave;
    private String nextHopMaster;
    private String nextHopSlave;
    private String vrfID;
    private String vrfName;
    private int vrID;

    public L3vpnStaticFrrUniResIDParser() {
    }

    public L3vpnStaticFrrUniResIDParser(int devID, int vrID, String vrfID, String vrfName, String masterIfName, String slaveIfName, String masterHop, String slaveHop) {
        this.devID = devID;
        this.vrID = vrID;
        this.ifNameMaster = masterIfName;
        this.ifNameSlave = slaveIfName;
        this.nextHopMaster = masterHop;
        this.nextHopSlave = slaveHop;
        this.vrfID = vrfID;
        this.vrfName = vrfName;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        this.checkFDN(fdn);
        StrUIDParser parser = this.parseFdn(fdn, TYPE);
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = new StrSpliter();
        spliter.parse(parser.strValue("VRF"));
        if (spliter.next()) {
            this.setVrfID(spliter.strValue());
        }
        if (spliter.next()) {
            this.setVrfName(spliter.strValue());
        }
        StrUIDParser parserFrr = this.parseFdn(fdn, TYPE);
        StrSpliter spliterFrr = this.parseFragment(parserFrr.strValue(this.getMOType()));
        this.setFrrParas(spliterFrr);
        return null;
    }

    public int getDevID() {
        return this.devID;
    }

    public String getFrrName() {
        return this.frrName;
    }

    public String getIfNameMaster() {
        return this.ifNameMaster;
    }

    public String getIfNameSlave() {
        return this.ifNameSlave;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    public String getNextHopMaster() {
        return this.nextHopMaster;
    }

    public String getNextHopSlave() {
        return this.nextHopSlave;
    }

    public String getVrfID() {
        return this.vrfID;
    }

    public String getVrfName() {
        return this.vrfName;
    }

    public int getVrID() {
        return this.vrID;
    }

    @Override
    public String serialize() throws UIDParseException {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (0 != this.vrID) {
            factory.append("VR", (long)this.vrID);
        }
        factory.append("VRF", this.vrfID + '|' + this.vrfName);
        StrLinker linker = new StrLinker();
        linker.append(this.frrName);
        AsnUtil.linkFdnFragment(linker, this.nextHopMaster);
        AsnUtil.linkFdnFragment(linker, this.nextHopSlave);
        AsnUtil.linkFdnFragment(linker, this.ifNameMaster);
        AsnUtil.linkFdnFragment(linker, this.ifNameSlave);
        factory.append(this.getMOType(), linker.getStr());
        return factory.getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setFrrName(String frrName) {
        this.frrName = frrName;
    }

    public void setIfNameMaster(String ifNameMaster) {
        this.ifNameMaster = ifNameMaster;
    }

    public void setIfNameSlave(String ifNameSlave) {
        this.ifNameSlave = ifNameSlave;
    }

    public void setNextHopMaster(String nextHopMaster) {
        this.nextHopMaster = nextHopMaster;
    }

    public void setNextHopSlave(String nextHopSlave) {
        this.nextHopSlave = nextHopSlave;
    }

    public void setVrfID(String vrfID) {
        this.vrfID = vrfID;
    }

    public void setVrfName(String vrfName) {
        this.vrfName = vrfName;
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    private void checkFDN(String fdn) {
        if (fdn == null || fdn.isEmpty()) {
            throw new IllegalArgumentException("can't parse null or empty fdn.");
        }
    }

    private void setFrrParas(StrSpliter spliter) {
        int i = 0;
        while (spliter.next()) {
            switch (i) {
                case 0: {
                    this.frrName = spliter.strValue();
                    break;
                }
                case 1: {
                    this.nextHopMaster = spliter.strValue();
                    break;
                }
                case 2: {
                    this.nextHopSlave = spliter.strValue();
                    break;
                }
                case 3: {
                    this.ifNameMaster = spliter.strValue();
                    break;
                }
                case 4: {
                    this.ifNameSlave = spliter.strValue();
                    break;
                }
            }
            ++i;
        }
    }
}

