/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.PhysicalEntityResIDParser;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.extendpoint.framework.ISwitchPortName;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceUniResIDParser
extends PhysicalEntityResIDParser {
    public static final String TYPE = "LP";
    private static final int ILLEGAL_PORT_NUMBER = -1;
    private static final Logger logger = LoggerFactory.getLogger(InterfaceUniResIDParser.class);
    private static final int POSITION_FRAME = 4;
    private static final int POSITION_WITHOUT_FRAME = 3;
    private static final int SERIAL_TYPE = 65543;
    private boolean bPortType;
    private int devID;
    private int frameID;
    private Integer domainID;
    private String ifName;
    private long portID;
    private int portType;
    private int slotID;
    private int subslotID;
    private Integer vrID;

    public InterfaceUniResIDParser() {
        this(-1, null, null);
    }

    public InterfaceUniResIDParser(int devID, Integer vrID, String ifName) {
        this.devID = devID;
        this.vrID = vrID;
        this.ifName = ifName;
        this.portType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName(ifName);
        if (null != ifName && ifName.contains("/")) {
            this.bPortType = true;
            this.frameID = 1;
            String position = FDNUtil.getPostionFromIfName(ifName);
            String[] coordinate = position.split("/");
            if (65543 == this.portType) {
                String[] serialport = null;
                if (4 == coordinate.length) {
                    this.slotID = Integer.parseInt(coordinate[0]);
                    this.subslotID = Integer.parseInt(coordinate[1]);
                    serialport = coordinate[3].split(":");
                } else if (3 == coordinate.length) {
                    this.slotID = Integer.parseInt(coordinate[0]);
                    this.subslotID = Integer.parseInt(coordinate[1]);
                    serialport = coordinate[2].split(":");
                }
                this.portID = 1 < serialport.length ? (long)Integer.parseInt((String)serialport[1]) : (long)Integer.parseInt((String)serialport[0]);
            } else if (4 == coordinate.length) {
                this.frameID = Integer.parseInt(coordinate[0]);
                this.slotID = Integer.parseInt(coordinate[1]);
                this.subslotID = Integer.parseInt(coordinate[2]);
                this.portID = Integer.parseInt(coordinate[3]);
            } else if (3 == coordinate.length) {
                this.slotID = Integer.parseInt(coordinate[0]);
                this.subslotID = Integer.parseInt(coordinate[1]);
                this.portID = Integer.parseInt(coordinate[2]);
            }
        } else {
            this.bPortType = false;
            this.frameID = -1;
            this.slotID = -1;
            this.subslotID = -1;
            this.portID = FDNUtil.getPortNumFromIfName(ifName);
        }
    }

    public static void main(String[] args) {
        String ifName = "Eth-Trunk4";
        InterfaceUniResIDParser parse = new InterfaceUniResIDParser(1, 1, ifName);
        System.err.println(parse.serialize());
    }

    @Override
    public Object deserialize(String fdn) {
        StrUIDParser parser = this.parseFdn(fdn, TYPE);
        this.decode(parser);
        return this;
    }

    public int getDevID() {
        return this.devID;
    }

    public Integer getDomainID() {
        return this.domainID;
    }

    public String getIfName() {
        return this.ifName;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    @Override
    public final String getPostion() {
        return FDNUtil.getPostionFromIfName(this.ifName);
    }

    public int getVrID() {
        return null == this.vrID ? 0 : this.vrID;
    }

    @Override
    public String serialize() {
        return this.encode().getStr();
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setDomainID(Integer domainID) {
        this.domainID = domainID;
    }

    public void setIfName(String ifName) {
        this.ifName = ifName;
    }

    @Override
    public final void setPostion(String position) {
    }

    public void setVrID(int vrID) {
        this.vrID = vrID;
    }

    void decode(StrUIDParser parser) {
        this.setDevID(this.intValue(parser.strValue("NE"), -1));
        this.setVrID(this.intValue(parser.strValue("VR"), 0));
        StrSpliter spliter = this.parseFragment(parser.strValue(TYPE));
        spliter.next();
        if (spliter.next()) {
            this.portType = this.intValue(spliter, -1);
        }
        if (spliter.next()) {
            this.portID = this.intValue(spliter, -1);
        }
        if (spliter.next()) {
            ISwitchPortName portName = (ISwitchPortName)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(ISwitchPortName.class);
            this.ifName = portName != null ? portName.convertToVrpVlanSubPortName(this.devID, this.portID) : spliter.strValue();
        }
    }

    StrUIDFactory encode() {
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        if (null != this.vrID && !this.vrID.equals(0)) {
            factory.append("VR", (long)this.vrID.intValue());
        }
        if (this.bPortType) {
            factory.append("FR", (long)this.frameID);
            factory.append("S", (long)this.slotID);
            factory.append("CP", -1L);
            factory.append("SS", (long)this.subslotID);
            factory.append("SC", -1L);
        }
        StrLinker linker = new StrLinker();
        linker.append(null == this.domainID ? "" : this.domainID.toString()).append((long)this.portType).append(this.portID).append(this.ifName);
        factory.append(TYPE, linker.getStr());
        return factory;
    }
}

