/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.PhysicalEntityResIDParser;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameUniResIDParser
extends PhysicalEntityResIDParser {
    private static final Logger logger = LoggerFactory.getLogger(FrameUniResIDParser.class);
    private int devID;
    private int frameID;

    public FrameUniResIDParser() {
        this.devID = -1;
        this.frameID = -1;
    }

    public FrameUniResIDParser(int devID, int frameID) {
        this.devID = devID;
        this.frameID = frameID;
    }

    @Override
    public Object deserialize(String fdn) throws UIDParseException {
        ToStringBuilder buf = new ToStringBuilder((Object)"deserialize frame fdn");
        buf.append("FDN", (Object)fdn);
        try {
            StrUIDParser parser = new StrUIDParser();
            if (!parser.parse(fdn)) {
                buf.append("RESULT", (Object)"parse fail");
                throw new UIDParseException(buf.toString());
            }
            while (parser.next()) {
                String type = parser.type();
                if ("NE".equals(type)) {
                    this.setDevID((int)parser.intValue());
                }
                if (!"FR".equals(type)) continue;
                this.setFrameID((int)parser.intValue());
            }
        }
        catch (Exception e) {
            buf.append("RESULT", (Object)"exception");
            throw new UIDParseException(buf.toString(), e);
        }
        return this;
    }

    public int getDevID() {
        return this.devID;
    }

    public int getFrameID() {
        return this.frameID;
    }

    @Override
    public String getMOType() {
        return "FR";
    }

    @Override
    public final String getPostion() {
        return String.valueOf(this.frameID);
    }

    @Override
    public String serialize() {
        ToStringBuilder buf = new ToStringBuilder((Object)"serialize frame to fdn");
        buf.append("DEVID", this.devID);
        buf.append("FRAME", this.frameID);
        if (this.devID < 0 || this.frameID < 0) {
            buf.append("RESULT", (Object)"illegal");
            return "";
        }
        StrUIDFactory factory = new StrUIDFactory();
        factory.append("NE", (long)this.devID);
        factory.append("FR", (long)this.frameID);
        String fdn = factory.getStr();
        buf.append("RESULT", (Object)fdn);
        logger.info(buf.toString());
        return fdn;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setFrameID(int frameID) {
        this.frameID = frameID;
    }

    @Override
    public final void setPostion(String position) {
        this.frameID = Integer.parseInt(position);
    }
}

