/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FDNUtil {
    private static final Pattern ifNamePortNumberPattern = Pattern.compile("[\\d]*[/]?[\\d]+/[\\d]+/([\\d]+)|([\\d]+)");
    private static final Pattern ifNamePostitionPattern = Pattern.compile("([\\d]*[/]?[\\d]+/[\\d]+/[\\d]+[:]?[\\d]*)");

    public static String getFdnType(String fdn) {
        StrUIDParser parser = new StrUIDParser();
        parser.parse(fdn);
        return parser.getMOC();
    }

    public static long getPortNumFromIfName(String ifName) {
        Matcher matcher;
        long portNum = -1L;
        if (ifName != null && (matcher = ifNamePortNumberPattern.matcher(ifName)).find()) {
            String group = matcher.group(1);
            if (!StringUtils.isNumeric((String)group)) {
                group = matcher.group(2);
            }
            if (StringUtils.isNumeric((String)group)) {
                portNum = Long.parseLong(group);
            }
        }
        return portNum;
    }

    public static String getPostionFromIfName(String ifName) {
        String pos = "";
        if (ifName != null) {
            boolean MATCH_GROUP = true;
            Matcher matcher = ifNamePostitionPattern.matcher(ifName);
            if (matcher.find()) {
                pos = matcher.group(1);
            }
        }
        return pos;
    }
}

