/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.PhysicalEntityResIDParser;

public class CardUniResIDParser
extends PhysicalEntityResIDParser {
    public static final String TYPE = "CP";
    private int cardID;
    private int devID;
    private int frameID;
    private int slotID;

    public CardUniResIDParser() {
    }

    public CardUniResIDParser(int devID, int frameID, int slotID) {
        this.devID = devID;
        this.frameID = frameID;
        this.slotID = slotID;
        this.cardID = -1;
    }

    public CardUniResIDParser(int devID, String position) {
        assert (position != null) : "position is null";
        this.devID = devID;
        this.setPostion(position);
    }

    @Override
    public Object deserialize(String fdn) {
        StrUIDParser parser = new StrUIDParser();
        if (!parser.parse(fdn)) {
            throw new UIDParseException(String.format("StrUIDParser.parse(%s) fail.", fdn));
        }
        this.decode(parser);
        return null;
    }

    public int getCardID() {
        return this.cardID;
    }

    public int getDevID() {
        return this.devID;
    }

    public int getFrameID() {
        return this.frameID;
    }

    @Override
    public String getMOType() {
        return TYPE;
    }

    @Override
    public final String getPostion() {
        StringBuffer position = new StringBuffer();
        position.append(this.frameID).append("/").append(this.slotID);
        return position.toString();
    }

    public int getSlotID() {
        return this.slotID;
    }

    @Override
    public String serialize() {
        StrUIDFactory oFactory = new StrUIDFactory();
        this.encode(oFactory);
        return oFactory.getStr();
    }

    public void setCardID(int cardID) {
        this.cardID = cardID;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public void setFrameID(int frameID) {
        this.frameID = frameID;
    }

    @Override
    public final void setPostion(String position) {
        String[] coordinate = position.split("/");
        if (coordinate.length == 1) {
            this.frameID = 1;
            this.slotID = Integer.parseInt(coordinate[0]);
        } else if (coordinate.length == 2) {
            this.frameID = Integer.parseInt(coordinate[0]);
            this.slotID = Integer.parseInt(coordinate[1]);
        }
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    void decode(StrUIDParser parser) {
        this.devID = this.intValue(parser.strValue("NE"), -1);
        this.frameID = this.intValue(parser.strValue("FR"), -1);
        this.slotID = this.intValue(parser.strValue("S"), -1);
        this.cardID = this.intValue(parser.strValue(TYPE), -1);
    }

    void encode(StrUIDFactory factory) {
        factory.append("NE", (long)this.devID);
        factory.append("FR", (long)this.frameID);
        factory.append("S", (long)this.slotID);
        factory.append(TYPE, -1L);
    }
}

