/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.fdn;

import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.exception.UIDParseException;
import com.huawei.vmf.adapter.common.fdn.UniResIDParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractUniResIDParser
implements UniResIDParser {
    public static final int INVALIDNE = -1;
    public static final int INVALIDVR = 0;
    private static final Logger logger = LoggerFactory.getLogger(AbstractUniResIDParser.class);

    public abstract String getMOType();

    public int intValue(String strValue, int defaultValue) {
        int ret = defaultValue;
        if (StringUtils.hasText((String)strValue)) {
            try {
                ret = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                logger.warn("parse string to integer exception, return default value:{}", (Object)strValue);
            }
        }
        return ret;
    }

    public int intValue(StrSpliter spliter, int defaultValue) {
        String str = spliter.strValue();
        int ret = defaultValue;
        if (StringUtils.hasText((String)str)) {
            try {
                ret = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                logger.warn("parse string to integer exception, return default value:{}", (Object)str);
            }
        }
        return ret;
    }

    public StrUIDParser parseFdn(String fdn, String mocType) throws UIDParseException {
        StrUIDParser parser = new StrUIDParser();
        if (!parser.parse(fdn)) {
            throw new UIDParseException(String.format("StrUIDParser.parse(%s) fail.", fdn));
        }
        if (!mocType.equals(parser.getMOC())) {
            throw new UIDParseException("expect MOC:" + mocType + ", but actual is:" + parser.getMOC());
        }
        return parser;
    }

    public StrSpliter parseFragment(String fragment) throws UIDParseException {
        StrSpliter spliter = new StrSpliter();
        if (!spliter.parse(fragment)) {
            throw new UIDParseException(String.format("StrUIDParser.parse(%s) fail.", fragment));
        }
        return spliter;
    }
}

