/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindService;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdBindServiceTranslator;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdInfoTranslator;
import com.huawei.vmf.adapter.bfd.util.BfdKeyParser;
import com.huawei.vmf.adapter.bfd.util.BfdUtil;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.math.BigInteger;
import org.slf4j.Logger;

public class QAsnBfdInfoSpecTranslator
extends AbstractAsnSpecTranslator<QAsnBfdInfoTranslator> {
    private static final int RI_BFDADMINSTATUS_CHG = 2;
    private static final int RI_BFDDESC_CHG = 1;
    private static final int RI_BFDDETECTMULT_CHG = 32;
    private static final int RI_BFDISCOMMIT_CHG = 2048;
    private static final int RI_BFDLOCALID_CHG = 8192;
    private static final int RI_BFDMINRX_CHG = 16;
    private static final int RI_BFDMINTX_CHG = 8;
    private static final int RI_BFDPROCESSIF_CHG = 256;
    private static final int RI_BFDPROCESSPST_CHG = 512;
    private static final int RI_BFDREMOTEID_CHG = 16384;
    private static final int RI_BFDSERVICETYPE_CHG = 1024;
    private static final int RI_BFDSESSIONSTATUS_CHG = 4096;
    private static final int RI_BFDSESSIONTYPE_CHG = 4;
    private static final int RI_BFDTOSEXP_CHG = 64;
    private static final int RI_BFDWTR_CHG = 128;
    private static final Object[][] z_qasnBfdInfoMasks = new Object[][]{{"strDescription", 1}, {"iAdminStatus", 2}, {"iSessionType", 4}, {"iMinTxInterval", 8}, {"iMinRxInterval", 16}, {"iDetectMult", 32}, {"iTosExp", 64}, {"iWtr", 128}, {"isProcessIf", 256}, {"isProcessPst", 512}, {"iServiceType", 1024}, {"isCommit", 2048}, {"iSessionStatus", 4096}, {"iLocalID", 8192}, {"iRemoteID", 16384}};
    private final Logger logger = RunLogger.getLogger(((Object)((Object)this)).getClass());

    public void decodeIAdminStatus(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setAdminDown(AsnTranslatorUtil.parseBoolean((Boolean)(asn.iAdminStatus == 2 ? 1 : 0), (String)"adminDown", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIDetectMult(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setDetectMulti(AsnTranslatorUtil.integerValue((int)asn.iDetectMult, (String)"detectMulti", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeILocalID(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setLocalDiscr(AsnTranslatorUtil.longValue((int)asn.iLocalID, (String)"localDiscr", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIMinRxInterval(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setMinRxInt(AsnTranslatorUtil.integerValue((int)asn.iMinRxInterval, (String)"minRxInt", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIMinTxInterval(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setMinTxInt(AsnTranslatorUtil.integerValue((int)asn.iMinTxInterval, (String)"minTxInt", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIRemoteID(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setRemoteDiscr(AsnTranslatorUtil.longValue((int)asn.iRemoteID, (String)"remoteDiscr", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeISessionStatus(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setSessState(AsnTranslatorUtil.integerValue((int)asn.iSessionStatus, (String)"sessState", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeISessionType(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        if (1 == asn.iSessionType && null != asn.poAutoNegotiate && 1 == asn.poAutoNegotiate) {
            mo.setCreateType(Integer.valueOf(1));
        } else if (1 == asn.iSessionType && (null == asn.poAutoNegotiate || null != asn.poAutoNegotiate && 1 != asn.poAutoNegotiate)) {
            mo.setCreateType(Integer.valueOf(0));
        } else if (3 == asn.iSessionType && null != asn.poAutoNegotiate && 1 == asn.poAutoNegotiate) {
            mo.setCreateType(Integer.valueOf(1));
            mo.setBfdHopType(Integer.valueOf(0));
        } else if (3 == asn.iSessionType && (null == asn.poAutoNegotiate || null != asn.poAutoNegotiate && 1 != asn.poAutoNegotiate)) {
            mo.setCreateType(Integer.valueOf(0));
            mo.setBfdHopType(Integer.valueOf(0));
        } else if (4 == asn.iSessionType && null != asn.poAutoNegotiate && 1 == asn.poAutoNegotiate) {
            mo.setCreateType(Integer.valueOf(1));
            mo.setBfdHopType(Integer.valueOf(1));
        } else if (4 == asn.iSessionType && (null == asn.poAutoNegotiate || null != asn.poAutoNegotiate && 1 != asn.poAutoNegotiate)) {
            mo.setCreateType(Integer.valueOf(0));
            mo.setBfdHopType(Integer.valueOf(1));
        } else {
            mo.setCreateType(Integer.valueOf(0));
        }
    }

    public void decodeIsProcessIf(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setPis(AsnTranslatorUtil.parseBoolean((Boolean)(1 == asn.isProcessIf ? 1 : 0), (String)"pis", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        mo.setPisSubIf(AsnTranslatorUtil.parseBoolean((Boolean)(3 == asn.isProcessIf ? 1 : 0), (String)"pisSubIf", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIsProcessPst(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        String strfdn;
        if (null == asn || null == mo) {
            return;
        }
        if (null != asn.poBfdBindService && null != asn.poBfdBindService.poBfdBindVrfIp && null != asn.poBfdBindService.poBfdBindVrfIp.poOutInfFdn && (strfdn = StringUtil.globalString((byte[])asn.poBfdBindService.poBfdBindVrfIp.poOutInfFdn.strFDN)).indexOf("SUBIF") > -1) {
            mo.setProcessPst(Boolean.FALSE);
            return;
        }
        if (null != asn.poBfdBindService && null != asn.poBfdBindService.poBfdBindIpLink && null != asn.poBfdBindService.poBfdBindIpLink.poOutInfFdn && (strfdn = StringUtil.globalString((byte[])asn.poBfdBindService.poBfdBindIpLink.poOutInfFdn.strFDN)).indexOf("SUBIF") > -1) {
            mo.setProcessPst(Boolean.FALSE);
            return;
        }
        mo.setProcessPst(AsnTranslatorUtil.parseBoolean((Boolean)asn.isProcessPst, (String)"processPst", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeITosExp(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setTosExp(AsnTranslatorUtil.integerValue((int)asn.iTosExp, (String)"tosExp", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeIWtr(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        if (-1 != asn.iWtr) {
            mo.setWtrTimerInt(AsnTranslatorUtil.integerValue((int)asn.iWtr, (String)"wtrTimerInt", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
        }
    }

    public void decodeKeyProperties(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == asn.bfdFdn) {
            return;
        }
        mo.setDevID(Integer.valueOf(asn.neID));
        mo.setVrID(Integer.valueOf(0));
        String strName = BfdUtil.getBfdName(AsnUtil.strValue((byte[])asn.bfdFdn.strFDN));
        if (null == strName || "--".equals(strName)) {
            mo.setSessName(AsnUtil.strValue((byte[])asn.strName));
        } else {
            mo.setSessName(strName);
        }
        QAsnBfdBindServiceTranslator bindserTran = new QAsnBfdBindServiceTranslator();
        try {
            bindserTran.decode(asn.poBfdBindService, mo, context);
        }
        catch (VMFException e) {
            this.logger.debug("translator bfdBindService asn failed", (Throwable)e);
        }
    }

    public void decodePoAutoNegotiate(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == asn.poAutoNegotiate) {
            return;
        }
        mo.setAutoCalc(Boolean.valueOf(asn.poAutoNegotiate == 1));
    }

    public void decodeQAsnBfdInfoSpecKeys(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
    }

    public void decodeStrDescription(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setDescription(AsnTranslatorUtil.strValue((byte[])asn.strDescription, (String)"description", (Object[][])z_qasnBfdInfoMasks, (VmfMO)mo, (IAsnTranslationContext)context));
    }

    public void decodeStrName(QAsnBfdInfo asn, BfdCfgSession mo, IAsnTranslationContext context) {
    }

    public void encodeIAdminStatus(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getAdminDown()) {
            return;
        }
        asn.iAdminStatus = null != mo.getAdminDown() && mo.getAdminDown() != false ? 2 : 1;
    }

    public void encodeIDetectMult(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getDetectMulti()) {
            return;
        }
        asn.iDetectMult = mo.getDetectMulti();
    }

    public void encodeILocalID(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getLocalDiscr()) {
            return;
        }
        if (mo.getLocalDiscr() <= Integer.MAX_VALUE) {
            asn.iLocalID = mo.getLocalDiscr().intValue();
        }
    }

    public void encodeIMinRxInterval(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getMinRxInt()) {
            return;
        }
        asn.iMinRxInterval = mo.getMinRxInt();
    }

    public void encodeIMinTxInterval(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getMinTxInt()) {
            return;
        }
        asn.iMinTxInterval = mo.getMinTxInt();
    }

    public void encodeIRemoteID(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getRemoteDiscr()) {
            return;
        }
        if (mo.getRemoteDiscr() <= Integer.MAX_VALUE) {
            asn.iRemoteID = mo.getRemoteDiscr().intValue();
        }
    }

    public void encodeISessionStatus(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getSessState()) {
            return;
        }
        asn.iSessionStatus = mo.getSessState() + 1;
    }

    public void encodeISessionType(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getCreateType()) {
            return;
        }
        if (null == mo.getBfdHopType()) {
            asn.iSessionType = 1;
            return;
        }
        asn.iSessionType = 0 == mo.getBfdHopType() ? 3 : (1 == mo.getBfdHopType() ? 4 : (0 == mo.getCreateType() ? 1 : (1 == mo.getCreateType() ? 1 : 1)));
    }

    public void encodeIsProcessIf(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        asn.isProcessIf = null != mo.getPis() && mo.getPis() != false ? 1 : (null != mo.getPisSubIf() && mo.getPisSubIf() != false ? 3 : 2);
    }

    public void encodeIsProcessPst(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        if (null != mo.getProcessPst()) {
            asn.isProcessPst = mo.getProcessPst();
        }
    }

    public void encodeITosExp(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getTosExp()) {
            return;
        }
        asn.iTosExp = mo.getTosExp();
    }

    public void encodeIWtr(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        asn.iWtr = null != mo.getWtrTimerInt() ? mo.getWtrTimerInt() : -1;
    }

    public void encodeKeyProperties(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getDevID()) {
            return;
        }
        asn.neID = mo.getDevID();
        asn.strName = mo.getSessName().getBytes();
        BfdKeyParser parser = new BfdKeyParser(mo.getDevID(), mo.getSessName());
        asn.bfdFdn.neID = mo.getDevID();
        asn.bfdFdn.strMOC = "BFD".getBytes();
        asn.bfdFdn.strFDN = parser.serialize().getBytes();
        asn.iServiceType = BigInteger.ZERO.intValue();
        asn.isCommit = true;
        asn.iBfdDeployStatus = BigInteger.ONE.intValue();
        QAsnBfdBindServiceTranslator bindserTran = new QAsnBfdBindServiceTranslator();
        if (mo.getLinkType() != null) {
            try {
                asn.poBfdBindService = new QAsnBfdBindService();
                bindserTran.encode(mo, asn.poBfdBindService, context);
            }
            catch (VMFException e) {
                this.logger.debug("encode bfdBindService asn failed", (Throwable)e);
            }
        }
    }

    public void encodePoAutoNegotiate(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        asn.poAutoNegotiate = null != mo.getAutoCalc() && mo.getAutoCalc() != false ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public void encodeStrDescription(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        asn.strDescription = null == mo.getDescription() ? "--".getBytes() : mo.getDescription().getBytes();
    }

    public void encodeStrName(BfdCfgSession mo, QAsnBfdInfo asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getSessName()) {
            return;
        }
        asn.strName = mo.getSessName().getBytes();
    }
}

