/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindVllEdgePw;
import com.huawei.vmf.adapter.bfd.Activator;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdBindVllEdgePwTranslator;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.PwUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.Pwe3UniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.model.L2vpnAc;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.service.IPwe3Service;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnBfdBindVllEdgePwSpecTranslator
extends AbstractAsnSpecTranslator<QAsnBfdBindVllEdgePwTranslator> {
    private IPwe3Service pwe3Service;
    private Pwe3UniResIDParser pwe3UniResIDParser = new Pwe3UniResIDParser();
    private IFdnParser<VpwsPw> vpwsPwFdnParser = new VpwsPwFdnParser();

    public void decodeKeyProperties(QAsnBfdBindVllEdgePw asn, BfdCfgSession mo, IAsnTranslationContext context) {
        Collection lstVpwsInstance;
        if (null == asn || null == mo || null == asn.poPwFdn) {
            return;
        }
        mo.setOutIfName("--");
        mo.setPwSecondary(Boolean.valueOf(false));
        String fdn = AsnUtil.strValue((byte[])asn.poPwFdn.strFDN);
        PwUniResIDParser parser = new PwUniResIDParser();
        parser.deserialize(fdn);
        Long iVcId = parser.getPwID();
        try {
            lstVpwsInstance = this.getDeviceService().getVpwsInstances(fdn);
        }
        catch (VMFException e) {
            this.getLogger().error("get VpwsInstances error", (Throwable)e);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)lstVpwsInstance)) {
            return;
        }
        for (VpwsInstance vpwsInstance : lstVpwsInstance) {
            if (CollectionUtils.isEmpty((Collection)vpwsInstance.getL2vpnAcs())) continue;
            for (L2vpnAc l2vpnAc : vpwsInstance.getL2vpnAcs()) {
                String strIfName = l2vpnAc.getInterfaceName();
                mo.setOutIfName(strIfName);
            }
            if (CollectionUtils.isEmpty((Collection)vpwsInstance.getVpwsPws())) continue;
            for (VpwsPw vpwsPw : vpwsInstance.getVpwsPws()) {
                if (!iVcId.equals(vpwsPw.getPwId())) continue;
                mo.setPwSecondary(Boolean.valueOf(vpwsPw.getPwRole() == 2));
            }
        }
    }

    public void decodeQAsnBfdBindVllEdgePwSpecKeys(QAsnBfdBindVllEdgePw asn, BfdCfgSession mo, IAsnTranslationContext context) {
    }

    public void encodeKeyProperties(BfdCfgSession mo, QAsnBfdBindVllEdgePw asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getDevID() || null == mo.getOutIfName()) {
            return;
        }
        if (null == asn.poPwFdn) {
            asn.poPwFdn = new QAsnUniResID();
        }
        asn.poPwFdn.neID = mo.getDevID();
        asn.poPwFdn.strMOC = "PW".getBytes();
        asn.poPwFdn.strFDN = "--".getBytes();
        asn.poPwFdn.poSerialNum = null;
        String strFdn = "--";
        int iPwRole = -1;
        iPwRole = mo.getPwSecondary() != false ? 2 : 1;
        try {
            strFdn = this.getDeviceService().getPwFdn(mo.getDevID(), mo.getOutIfName(), Integer.valueOf(iPwRole));
        }
        catch (VMFException e) {
            this.getLogger().error("get Pw Fdn error", (Throwable)e);
            return;
        }
        if (null != strFdn) {
            asn.poPwFdn.strFDN = strFdn.getBytes();
        }
    }

    private IPwe3Service getDeviceService() throws VMFException {
        if (this.pwe3Service == null) {
            this.pwe3Service = Activator.getService(IPwe3Service.class);
        }
        return this.pwe3Service;
    }
}

