/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindService;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdBindIpLinkTranslator;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdBindServiceTranslator;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsInstance;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class QAsnBfdBindServiceSpecTranslator
extends AbstractAsnSpecTranslator<QAsnBfdBindServiceTranslator> {
    private Logger logger = RunLogger.getLogger(((Object)((Object)this)).getClass());
    private QAsnBfdBindIpLinkTranslator qAsnBfdBindIpLinkTranslator = new QAsnBfdBindIpLinkTranslator();

    public void decodeIBindServiceType(QAsnBfdBindService asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        switch (asn.iBindServiceType) {
            case 6: 
            case 8: {
                mo.setLinkType(Integer.valueOf(5));
                break;
            }
            case 3: {
                mo.setLinkType(Integer.valueOf(4));
                break;
            }
            case 4: {
                mo.setLinkType(Integer.valueOf(3));
                break;
            }
            case 5: {
                mo.setLinkType(Integer.valueOf(2));
                break;
            }
            default: {
                mo.setLinkType(Integer.valueOf(0));
            }
        }
    }

    public void decodeKeyProperties(QAsnBfdBindService asn, BfdCfgSession mo, IAsnTranslationContext context) {
    }

    public void decodeQAsnBfdBindServiceSpecKeys(QAsnBfdBindService asn, BfdCfgSession mo, IAsnTranslationContext context) {
    }

    public void encodeIBindServiceType(BfdCfgSession mo, QAsnBfdBindService asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn || null == mo || null == mo.getLinkType()) {
            return;
        }
        int iType = mo.getLinkType();
        if (iType == 5 || 8 == iType) {
            VplsInstance vsi = new VplsInstance();
            vsi.setDevID(mo.getDevID());
            vsi.setVrID(Integer.valueOf(0));
            vsi.setInstanceName(mo.getVsiName());
            VplsInstance vplsMo = this.queryVplsVsi(vsi);
            asn.iBindServiceType = vplsMo.getAdminVsi().booleanValue() ? 6 : 8;
        } else {
            asn.iBindServiceType = iType == 4 ? 3 : (iType == 3 ? 4 : (iType == 2 ? 5 : (null != mo.getVrfName() && !"--".equals(mo.getVrfName()) ? 2 : 1)));
        }
    }

    public void encodeKeyProperties(BfdCfgSession mo, QAsnBfdBindService asn, IAsnTranslationContext context) {
    }

    private VplsInstance queryVplsVsi(VplsInstance instance) throws VMFException {
        Collection vsis = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(VplsInstance.class, Arrays.asList(instance), true);
        return CollectionUtils.isEmpty((Collection)vsis) ? null : (VplsInstance)vsis.iterator().next();
    }
}

