/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.translation.asn.spec;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdBindPwe3;
import com.huawei.vmf.adapter.bfd.Activator;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdBindPwe3Translator;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.Pwe3UniResIDParser;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.pwe3.service.IPwe3Service;

public class QAsnBfdBindPwe3SpecTranslator
extends AbstractAsnSpecTranslator<QAsnBfdBindPwe3Translator> {
    private IPwe3Service pwe3Service;
    private Pwe3UniResIDParser pwe3UniResIDParser = new Pwe3UniResIDParser();

    public void decodeKeyProperties(QAsnBfdBindPwe3 asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == asn.strPwe3Fdn) {
            return;
        }
        String fdn = AsnUtil.strValue((byte[])asn.strPwe3Fdn.strFDN);
        this.pwe3UniResIDParser.deserialize(fdn);
        mo.setOutIfName(this.pwe3UniResIDParser.getInterfaceName());
    }

    public void decodePwRole(QAsnBfdBindPwe3 asn, BfdCfgSession mo, IAsnTranslationContext context) {
        if (null == asn || null == mo) {
            return;
        }
        mo.setPwSecondary(Boolean.valueOf(asn.pwRole == 2));
    }

    public void decodeQAsnBfdBindPwe3SpecKeys(QAsnBfdBindPwe3 asn, BfdCfgSession mo, IAsnTranslationContext context) {
    }

    public void encodeKeyProperties(BfdCfgSession mo, QAsnBfdBindPwe3 asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getDevID()) {
            return;
        }
        if (null == asn.strPwe3Fdn) {
            asn.strPwe3Fdn = new QAsnUniResID();
        }
        asn.strPwe3Fdn.neID = mo.getDevID();
        asn.strPwe3Fdn.strMOC = "PWE3".getBytes();
        String fdn = "--";
        try {
            fdn = this.getDeviceService().getPwe3ServiceFdn(mo.getDevID(), mo.getOutIfName());
        }
        catch (VMFException e) {
            this.getLogger().error("get pwe3 fdn error", (Throwable)e);
        }
        if (null != fdn) {
            asn.strPwe3Fdn.strFDN = fdn.getBytes();
        }
        asn.strPwe3Fdn.poSerialNum = null;
    }

    public void encodePwRole(BfdCfgSession mo, QAsnBfdBindPwe3 asn, IAsnTranslationContext context) {
        if (null == asn || null == mo || null == mo.getPwSecondary()) {
            return;
        }
        asn.pwRole = mo.getPwSecondary() != false ? 2 : 1;
    }

    private IPwe3Service getDeviceService() throws VMFException {
        if (this.pwe3Service == null) {
            this.pwe3Service = Activator.getService(IPwe3Service.class);
        }
        return this.pwe3Service;
    }
}

