/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfoList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnGetBfdInfoByDevIDReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnGetBfdInfoByDevIDRsp;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdInfoTranslator;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdAllSession;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QueryBfdInfoByDevIDTask
extends AbstractQTask<QAsnGetBfdInfoByDevIDReq, QAsnGetBfdInfoByDevIDRsp> {
    protected void executeTask(QAsnGetBfdInfoByDevIDReq req, QAsnGetBfdInfoByDevIDRsp rsp, Task task) {
        this.getLogger().debug("QAsnGetBfdInfoByDevIDReq:{}", (Object)req);
        Collection<BfdCfgSession> lstBfdInfoLeft = this.queryBfdInfoByDevID(req.neID, req.iBindServiceType);
        QAsnBfdInfoList lstBfdRsp = new QAsnBfdInfoList();
        if (req.iPeerNeID != -1 && req.iPeerNeID != 0) {
            Collection<BfdCfgSession> lstBfdInfoRight = this.queryBfdInfoByDevID(req.iPeerNeID, req.iBindServiceType);
            if (null != lstBfdInfoLeft && !lstBfdInfoLeft.isEmpty() && null != lstBfdInfoRight && !lstBfdInfoRight.isEmpty()) {
                this.setPeerIDExistLsp(lstBfdRsp, lstBfdInfoLeft, lstBfdInfoRight);
            }
        } else {
            for (BfdCfgSession bfdInfoLeft : lstBfdInfoLeft) {
                lstBfdRsp.add((Object)this.translateBfdCfgSession(bfdInfoLeft));
            }
        }
        QAsnSingleReturn rtn = new QAsnSingleReturn();
        rtn.retCode = 0;
        rtn.isSuccess = true;
        rsp.oResult = rtn;
        if (!CollectionUtils.isEmpty((Collection)lstBfdRsp)) {
            for (Object obj : lstBfdRsp) {
                Collection<BfdAllSession> bfdAllSessions;
                QAsnBfdInfo bfdInfo = (QAsnBfdInfo)obj;
                if (-1 == bfdInfo.iLocalID && !CollectionUtils.isEmpty(bfdAllSessions = this.queryBfdAllSessionInfo(bfdInfo))) {
                    BfdAllSession bfdAllSession = bfdAllSessions.iterator().next();
                    if (null != bfdAllSession && -1 != bfdAllSession.getLocalDiscr()) {
                        bfdInfo.iLocalID = bfdAllSession.getLocalDiscr();
                    }
                    if (null != bfdAllSession && -1 != bfdAllSession.getRemoteDiscr()) {
                        bfdInfo.iRemoteID = bfdAllSession.getRemoteDiscr();
                    }
                }
                rsp.lstBfdInfo.add((Object)bfdInfo);
            }
        }
    }

    private Collection<BfdAllSession> queryBfdLocalAndRemoteIDFromDev(QAsnBfdInfo asnBfd) {
        BfdAllSession mo = new BfdAllSession();
        mo.setDevID(Integer.valueOf(asnBfd.neID));
        mo.setSessName(AsnUtil.strValue((byte[])asnBfd.strName));
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(mo.getDevID().intValue());
        queryContext.addQueryAttributes(FeatureName.BFD, (VmfMO)mo, null);
        pollService.addQueryJob(queryContext);
        try {
            pollService.poll();
            String[] fieldNames = new String[]{"localDiscr", "remoteDiscr"};
            Context ctx = new Context();
            IMOChangeRecord record = ctx.addChangeRecord(BfdAllSession.class);
            record.addModify((Object)mo, Arrays.asList(fieldNames));
            DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, ctx).merge(false, new Class[]{BfdAllSession.class});
        }
        catch (Exception e) {
            this.getLogger().error("query bfd sessionstatus[" + mo.getDevID() + "] failed", (Throwable)e);
            asnBfd.poOperResult.isSuccess = false;
            return null;
        }
        return queryContext.getQueryResult(BfdAllSession.class);
    }

    private Collection<BfdAllSession> queryBfdAllSessionInfo(QAsnBfdInfo bfdDetailInfo) {
        try {
            ArrayList<Integer> lstDevID = new ArrayList<Integer>();
            lstDevID.add(bfdDetailInfo.neID);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            ArrayList<BfdAllSession> conditions = new ArrayList<BfdAllSession>();
            BfdAllSession bfdCfgSe = new BfdAllSession();
            bfdCfgSe.setDevID(Integer.valueOf(bfdDetailInfo.neID));
            bfdCfgSe.setSessName(AsnUtil.strValue((byte[])bfdDetailInfo.strName));
            conditions.add(bfdCfgSe);
            String[] fieldNames = new String[]{"devID", "sessName"};
            Collection bfdInfo = dao.queryByNeID(BfdAllSession.class, lstDevID, fieldNames, conditions, true);
            return bfdInfo;
        }
        catch (VMFException e) {
            this.getLogger().error("query BfdAllSession by devID failed", (Throwable)e);
            return null;
        }
    }

    private boolean checkIDEqual(BfdCfgSession bfdInfoLeft, BfdCfgSession bfdInfoRight) {
        if (null == bfdInfoLeft.getLocalDiscr() || null == bfdInfoLeft.getRemoteDiscr() || null == bfdInfoRight.getLocalDiscr() || null == bfdInfoRight.getRemoteDiscr()) {
            return false;
        }
        return bfdInfoLeft.getLocalDiscr().intValue() == bfdInfoRight.getRemoteDiscr().intValue() && bfdInfoLeft.getRemoteDiscr().intValue() == bfdInfoRight.getLocalDiscr().intValue();
    }

    private void deleteIp(Collection<BfdCfgSession> bfdInfo) {
        ArrayList<BfdCfgSession> lstHasIP = new ArrayList<BfdCfgSession>();
        for (BfdCfgSession bfd : bfdInfo) {
            if (bfd.getVrfName() != null && !bfd.getVrfName().isEmpty()) continue;
            lstHasIP.add(bfd);
        }
        for (int i = 0; i < lstHasIP.size(); ++i) {
            bfdInfo.remove(lstHasIP.get(i));
        }
    }

    private void deleteVrf(Collection<BfdCfgSession> bfdInfo) {
        ArrayList<BfdCfgSession> lstHasVrf = new ArrayList<BfdCfgSession>();
        for (BfdCfgSession bfd : bfdInfo) {
            if (bfd.getVrfName() == null || bfd.getVrfName().isEmpty()) continue;
            lstHasVrf.add(bfd);
        }
        for (int i = 0; i < lstHasVrf.size(); ++i) {
            bfdInfo.remove(lstHasVrf.get(i));
        }
    }

    private Collection<BfdCfgSession> queryBfdInfoByDevID(int devID, int iBindServiceType) {
        try {
            ArrayList<Integer> lstDevID = new ArrayList<Integer>();
            lstDevID.add(devID);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            if (-1 != iBindServiceType) {
                ArrayList<BfdCfgSession> conditions = new ArrayList<BfdCfgSession>();
                BfdCfgSession bfdCfgSe = new BfdCfgSession();
                bfdCfgSe.setDevID(Integer.valueOf(devID));
                bfdCfgSe.setLinkType(Integer.valueOf(this.setLinkType(iBindServiceType)));
                conditions.add(bfdCfgSe);
                String[] fieldNames = new String[]{"devID", "linkType"};
                Collection bfdInfo = dao.queryByNeID(BfdCfgSession.class, lstDevID, fieldNames, conditions, true);
                if (iBindServiceType == 1 && bfdInfo != null && !bfdInfo.isEmpty()) {
                    this.deleteVrf(bfdInfo);
                }
                if (iBindServiceType == 2 && bfdInfo != null && !bfdInfo.isEmpty()) {
                    this.deleteIp(bfdInfo);
                }
                return bfdInfo;
            }
            Collection bfdInfo = dao.queryByNeID(BfdCfgSession.class, lstDevID, true);
            return bfdInfo;
        }
        catch (VMFException e) {
            this.getLogger().error("query BfdCfgSession by devID failed", (Throwable)e);
            return null;
        }
    }

    private void setPeerIDExistLsp(QAsnBfdInfoList lstBfdRsp, Collection<BfdCfgSession> lstBfdInfoLeft, Collection<BfdCfgSession> lstBfdInfoRight) {
        for (BfdCfgSession bfdInfoLeft : lstBfdInfoLeft) {
            for (BfdCfgSession bfdInfoRight : lstBfdInfoRight) {
                if (!this.checkIDEqual(bfdInfoLeft, bfdInfoRight)) continue;
                lstBfdRsp.add((Object)this.translateBfdCfgSession(bfdInfoLeft));
                lstBfdRsp.add((Object)this.translateBfdCfgSession(bfdInfoRight));
            }
        }
    }

    private QAsnBfdInfo translateBfdCfgSession(BfdCfgSession bfdCfgSession) {
        try {
            QAsnBfdInfoTranslator translator = new QAsnBfdInfoTranslator();
            QAsnBfdInfo asn = new QAsnBfdInfo();
            AsnTranslationContext context = new AsnTranslationContext();
            translator.encode(bfdCfgSession, asn, (IAsnTranslationContext)context);
            return asn;
        }
        catch (VMFException e) {
            this.getLogger().error("mo(BfdCfgSession) translate to asn(QAsnBfdInfo) failed", (Throwable)e);
            return null;
        }
    }

    private int setLinkType(int iBindServiceType) {
        int iLinkType = 0;
        switch (iBindServiceType) {
            case 4: {
                iLinkType = 3;
                break;
            }
            case 5: {
                iLinkType = 2;
                break;
            }
            case 3: {
                iLinkType = 4;
                break;
            }
            case 6: {
                iLinkType = 5;
                break;
            }
            default: {
                iLinkType = 0;
            }
        }
        return iLinkType;
    }
}

