/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdKeyList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnModifyBfdReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnModifyBfdRsp;
import com.huawei.vmf.adapter.bfd.task.GetBfdInfoByKeyTask;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdInfoTranslator;
import com.huawei.vmf.adapter.bfd.util.BfdKeyParser;
import com.huawei.vmf.adapter.bfd.util.BfdUtil;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.Collection;
import java.util.Set;

public class ModifyBfdTask
extends AbstractSingleMoConfigQTask<QAsnModifyBfdReq, QAsnModifyBfdRsp, QAsnBfdInfo, QAsnBfdInfo, BfdCfgSession> {
    public ModifyBfdTask() {
        super(BfdCfgSession.class, EOperationType.MODIFY, (IAsnTranslator)new QAsnBfdInfoTranslator(), (IAsnTranslator)new QAsnBfdInfoTranslator());
        this.addMoCompositeService(BfdCfgSession.class, (ICompositeService)new DefaultCompositeService(BfdCfgSession.class));
    }

    protected void decode(QAsnModifyBfdReq req, Task task, IAsnTranslationContext context) {
        IMOChangeRecord record = context.getTransactionContext().addChangeRecord(BfdCfgSession.class);
        for (Object obj : req.lstBfdDetailInfo) {
            QAsnBfdInfo bfdInfo = (QAsnBfdInfo)obj;
            this.decoEveryMoModify(bfdInfo, (IMOChangeRecord<BfdCfgSession>)record, context);
        }
    }

    protected void encode(QAsnModifyBfdRsp rsp, IAsnTranslationContext asnTrasnslatorContext) {
        QAsnSingleReturn singleReturn = new QAsnSingleReturn();
        singleReturn.isSuccess = Boolean.TRUE;
        Context context = asnTrasnslatorContext.getTransactionContext();
        IMOChangeRecord bfdCfgSessionRecord = context.getChangeRecord(this.getMoClazz());
        OperResult operResult = context.getOperResult();
        Set bfdCfgSessions = bfdCfgSessionRecord.getAllChanges();
        boolean totalRes = true;
        for (BfdCfgSession bfdSee : bfdCfgSessions) {
            ErrorInfo errorInfo = operResult.getMoOperResult((VmfMO)bfdSee);
            QAsnBfdInfo asnBfd = this.translateBfdCfgSession(bfdSee, asnTrasnslatorContext);
            if (null == asnBfd) {
                totalRes = false;
                continue;
            }
            if (!AsnTranslatorUtil.getQAsnSingleReturn((VmfMO)bfdSee, (IAsnTranslationContext)asnTrasnslatorContext).isSuccess) {
                totalRes = false;
                if (null == asnBfd.poOperResult) {
                    asnBfd.poOperResult = new QAsnSingleReturn();
                }
                if (null != errorInfo) {
                    asnBfd.poOperResult.isSuccess = false;
                    asnBfd.poOperResult.retCode = errorInfo.getErrorCode();
                    asnBfd.poOperResult.reason = null != errorInfo.getErrorMessage() ? errorInfo.getErrorMessage().getBytes() : null;
                }
            }
            rsp.lstBfdDetailInfo.add((Object)asnBfd);
        }
        rsp.oResult.isSuccess = totalRes;
    }

    protected Integer getAsnBestEffort(QAsnModifyBfdReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnModifyBfdReq req) {
        return req.poTaskFlag;
    }

    protected Collection<QAsnBfdInfo> getDecodeAsns(QAsnModifyBfdReq req) {
        return req.lstBfdDetailInfo;
    }

    protected void setEncodeAsns(Collection<QAsnBfdInfo> encodeAsns, QAsnModifyBfdRsp rsp, IAsnTranslationContext context) {
    }

    private void decoEveryMoModify(QAsnBfdInfo bfdInfo, IMOChangeRecord<BfdCfgSession> record, IAsnTranslationContext context) {
        BfdCfgSession bfdSessMo = new BfdCfgSession();
        bfdSessMo.setDevID(Integer.valueOf(bfdInfo.neID));
        bfdSessMo.setSessName(BfdUtil.getBfdName(AsnUtil.strValue((byte[])bfdInfo.bfdFdn.strFDN)));
        BfdKeyParser keyPar = new BfdKeyParser(bfdSessMo.getDevID(), bfdSessMo.getSessName());
        GetBfdInfoByKeyTask queryTask = new GetBfdInfoByKeyTask();
        QAsnBfdKeyList keyList = new QAsnBfdKeyList();
        QAsnUniResID ursid = new QAsnUniResID();
        ursid.neID = bfdSessMo.getDevID();
        ursid.strFDN = keyPar.serialize().getBytes();
        keyList.add((Object)ursid);
        Collection<BfdCfgSession> bfdQuery = queryTask.queryBfdInfo(keyList);
        if (null == bfdQuery || bfdQuery.isEmpty()) {
            this.getLogger().error("bfd {} not exist", (Object)bfdSessMo.getSessName());
            this.setOperResult(bfdInfo, 1107498867, (VmfMO)bfdSessMo);
            return;
        }
        BfdCfgSession bfdOld = bfdQuery.iterator().next();
        bfdOld.setCreateType(Integer.valueOf(0));
        if (null == bfdInfo.poOperMask || 0 >= bfdInfo.poOperMask) {
            this.getLogger().error("bfd poOperMask not exist", (Object)bfdSessMo.getSessName());
            this.setOperResult(bfdInfo, 1107499878, (VmfMO)bfdSessMo);
            return;
        }
        this.setModifyItem(bfdInfo, bfdOld, record);
    }

    private void setModifyItem(QAsnBfdInfo bfdInfo, BfdCfgSession bfdOld, IMOChangeRecord<BfdCfgSession> record) {
        int iMask = bfdInfo.poOperMask;
        if ((iMask & 1) > 0) {
            String strOldDescription = bfdOld.getDescription();
            String strNewDescription = AsnUtil.strValue((byte[])bfdInfo.strDescription);
            bfdOld.setDescription(strNewDescription);
            record.addModify((Object)bfdOld, new PropertyChangeItem("description", (Object)strNewDescription, (Object)strOldDescription));
        }
        if ((iMask & 2) > 0) {
            Boolean isOldAdminDown = bfdOld.getAdminDown();
            Boolean isNewAdminDown = bfdInfo.iAdminStatus == 2;
            bfdOld.setAdminDown(isNewAdminDown);
            record.addModify((Object)bfdOld, new PropertyChangeItem("adminDown", (Object)isNewAdminDown, (Object)isOldAdminDown));
        }
        if ((iMask & 0x10) > 0) {
            Integer iOldMinRxInterval = bfdOld.getMinRxInt();
            int iNewMinRxInterval = bfdInfo.iMinRxInterval;
            bfdOld.setMinRxInt(iNewMinRxInterval == -1 ? null : Integer.valueOf(iNewMinRxInterval));
            record.addModify((Object)bfdOld, new PropertyChangeItem("minRxInt", (Object)iNewMinRxInterval, (Object)iOldMinRxInterval));
        }
        if ((iMask & 8) > 0) {
            Integer iOldMinTxInterval = bfdOld.getMinTxInt();
            int iNewMinTxInterval = bfdInfo.iMinTxInterval;
            bfdOld.setMinTxInt(iNewMinTxInterval == -1 ? null : Integer.valueOf(iNewMinTxInterval));
            record.addModify((Object)bfdOld, new PropertyChangeItem("minTxInt", (Object)iNewMinTxInterval, (Object)iOldMinTxInterval));
        }
        if ((iMask & 0x80) > 0) {
            Integer iOldWtrTimerInt = bfdOld.getWtrTimerInt();
            int iNewWtrTimerInt = bfdInfo.iWtr;
            bfdOld.setWtrTimerInt(iNewWtrTimerInt == -1 ? null : Integer.valueOf(iNewWtrTimerInt));
            record.addModify((Object)bfdOld, new PropertyChangeItem("wtrTimerInt", (Object)bfdInfo.iWtr, (Object)iOldWtrTimerInt));
        }
        if ((iMask & 0x40) > 0) {
            Integer iOldTosExp = bfdOld.getTosExp();
            int iNewTosExp = bfdInfo.iTosExp;
            bfdOld.setTosExp(iNewTosExp == -1 ? null : Integer.valueOf(iNewTosExp));
            record.addModify((Object)bfdOld, new PropertyChangeItem("tosExp", (Object)iNewTosExp, (Object)iOldTosExp));
        }
        if ((iMask & 0x20) > 0) {
            Integer iOldDetectMulti = bfdOld.getDetectMulti();
            int iNewDetectMulti = bfdInfo.iDetectMult;
            bfdOld.setDetectMulti(iNewDetectMulti == -1 ? null : Integer.valueOf(iNewDetectMulti));
            record.addModify((Object)bfdOld, new PropertyChangeItem("detectMulti", (Object)iNewDetectMulti, (Object)iOldDetectMulti));
        }
        if ((iMask & 0x100) > 0) {
            Boolean isOldPis = bfdOld.getPis();
            Boolean isOldPisSubIf = bfdOld.getPisSubIf();
            Boolean isNewPis = 1 == bfdInfo.isProcessIf;
            Boolean isNewPisSubIfs = 3 == bfdInfo.isProcessIf;
            bfdOld.setPis(isNewPis);
            bfdOld.setPisSubIf(isNewPisSubIfs);
            record.addModify((Object)bfdOld, new PropertyChangeItem("pis", (Object)isNewPis, (Object)isOldPis));
            record.addModify((Object)bfdOld, new PropertyChangeItem("pisSubIf", (Object)isNewPisSubIfs, (Object)isOldPisSubIf));
        }
        if ((iMask & 0x200) > 0) {
            Boolean isOldProcessPst = bfdOld.getProcessPst();
            Boolean isNewProcessPst = bfdInfo.isProcessPst;
            bfdOld.setProcessPst(isNewProcessPst);
            record.addModify((Object)bfdOld, new PropertyChangeItem("processPst", (Object)isNewProcessPst, (Object)isOldProcessPst));
        }
    }

    private void setOperResult(QAsnBfdInfo bfdinfo, int err, VmfMO mo) {
    }

    private QAsnBfdInfo translateBfdCfgSession(BfdCfgSession bfdCfgSession, IAsnTranslationContext context) {
        try {
            QAsnBfdInfoTranslator translator = new QAsnBfdInfoTranslator();
            QAsnBfdInfo asn = new QAsnBfdInfo();
            translator.encode(bfdCfgSession, asn, context);
            return asn;
        }
        catch (VMFException e) {
            this.getLogger().error("mo(BfdCfgSession) translate to asn(QAsnBfdInfo) failed", (Throwable)e);
            return null;
        }
    }
}

