/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdKeyList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnGetBfdInfoByKeyReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnGetBfdInfoByKeyRsp;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdInfoTranslator;
import com.huawei.vmf.adapter.bfd.util.BfdKeyParser;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdAllSession;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GetBfdInfoByKeyTask
extends AbstractQTask<QAsnGetBfdInfoByKeyReq, QAsnGetBfdInfoByKeyRsp> {
    public Collection<BfdCfgSession> queryBfdInfoNew(QAsnBfdKeyList bfdKeyLst, QAsnGetBfdInfoByKeyRsp rsp) {
        HashSet<BfdCfgSession> bfdSessionlist = new HashSet<BfdCfgSession>();
        if (!CollectionUtils.isEmpty((Collection)bfdKeyLst)) {
            for (Object bfdKey : bfdKeyLst) {
                QAsnUniResID fdn = (QAsnUniResID)bfdKey;
                Collection<BfdCfgSession> instances = this.queryBfdSessionFromDevNew(fdn, rsp);
                bfdSessionlist.addAll(instances);
            }
        }
        return bfdSessionlist;
    }

    public Collection<BfdCfgSession> queryBfdInfo(QAsnBfdKeyList bfdKeyLst) {
        HashSet<BfdCfgSession> bfdSessionlist = new HashSet<BfdCfgSession>();
        if (!CollectionUtils.isEmpty((Collection)bfdKeyLst)) {
            for (Object bfdKey : bfdKeyLst) {
                QAsnUniResID fdn = (QAsnUniResID)bfdKey;
                Collection<BfdCfgSession> instances = this.queryBfdInfoByKey(fdn);
                bfdSessionlist.addAll(instances);
            }
        }
        return bfdSessionlist;
    }

    protected void executeTask(QAsnGetBfdInfoByKeyReq req, QAsnGetBfdInfoByKeyRsp rsp, Task task) {
        QAsnSingleReturn sigRet;
        this.getLogger().debug("QAsnGetBfdInfoByDevIDReq:{}", (Object)req);
        rsp.oResult = sigRet = new QAsnSingleReturn();
        sigRet.isSuccess = true;
        sigRet.retCode = 0;
        sigRet.reason = "".getBytes();
        Collection<BfdCfgSession> bfdSessinLst = this.queryBfdInfo(req.lstBfdKey);
        if (CollectionUtils.isEmpty(bfdSessinLst)) {
            return;
        }
        Collection<QAsnBfdInfo> bfdInfoLst = this.translateBfdCfgSessionLst(bfdSessinLst, rsp);
        if (!CollectionUtils.isEmpty(bfdInfoLst)) {
            Iterator<QAsnBfdInfo> i$ = bfdInfoLst.iterator();
            while (i$.hasNext()) {
                String strfdn;
                QAsnBfdInfo obj;
                QAsnBfdInfo bfdDetailInfo = obj = i$.next();
                if (null != bfdDetailInfo.poBfdBindService && null != bfdDetailInfo.poBfdBindService.poBfdBindVrfIp && null != bfdDetailInfo.poBfdBindService.poBfdBindVrfIp.poOutInfFdn) {
                    strfdn = StringUtil.globalString((byte[])bfdDetailInfo.poBfdBindService.poBfdBindVrfIp.poOutInfFdn.strFDN);
                    bfdDetailInfo.iSessionType = StringUtils.hasText((String)strfdn) ? 3 : 4;
                } else if (null != bfdDetailInfo.poBfdBindService && null != bfdDetailInfo.poBfdBindService.poBfdBindVrfIp && null == bfdDetailInfo.poBfdBindService.poBfdBindVrfIp.poOutInfFdn) {
                    bfdDetailInfo.iSessionType = 4;
                } else {
                    this.getLogger().error("GetBfdInfoByKeyTask.executeTask(), bfdhopetype is not right");
                }
                if (null != bfdDetailInfo.poBfdBindService && null != bfdDetailInfo.poBfdBindService.poBfdBindIpLink && null != bfdDetailInfo.poBfdBindService.poBfdBindIpLink.poOutInfFdn) {
                    strfdn = StringUtil.globalString((byte[])bfdDetailInfo.poBfdBindService.poBfdBindIpLink.poOutInfFdn.strFDN);
                    if (StringUtils.hasText((String)strfdn)) {
                        bfdDetailInfo.iSessionType = 3;
                        continue;
                    }
                    bfdDetailInfo.iSessionType = 4;
                    continue;
                }
                if (null != bfdDetailInfo.poBfdBindService && null != bfdDetailInfo.poBfdBindService.poBfdBindIpLink && null == bfdDetailInfo.poBfdBindService.poBfdBindIpLink.poOutInfFdn) {
                    bfdDetailInfo.iSessionType = 4;
                    continue;
                }
                this.getLogger().error("GetBfdInfoByKeyTask.executeTask(), bfdhopetype is not right");
            }
            rsp.lstBfdInfo.addAll(bfdInfoLst);
        }
    }

    private Collection<BfdCfgSession> queryBfdSessionFromDevNew(QAsnUniResID uniResID, QAsnGetBfdInfoByKeyRsp rsp) {
        BfdKeyParser parser = new BfdKeyParser();
        BfdCfgSession Bfdmo = new BfdCfgSession();
        String strfdn = StringUtil.globalString((byte[])uniResID.strFDN);
        if (StringUtils.hasText((String)strfdn)) {
            parser.deserialize(strfdn);
            Bfdmo.setSessName(parser.getBfdName());
        }
        Bfdmo.setDevID(Integer.valueOf(uniResID.neID));
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(Bfdmo.getDevID().intValue());
        queryContext.addQueryAttributes(FeatureName.BFD, (VmfMO)Bfdmo, null);
        pollService.addQueryJob(queryContext);
        try {
            pollService.poll();
            ErrorInfo querErrInfo = pollService.getErrorInfo((VmfMO)Bfdmo);
            if (querErrInfo != null && 0 != querErrInfo.getErrorCode()) {
                rsp.oResult.retCode = querErrInfo.getErrorCode();
                rsp.oResult.reason = null == querErrInfo.getErrorMessage() ? "".getBytes() : querErrInfo.getErrorMessage().getBytes();
                this.getLogger().error("queryBfdSessionFromDev errorInfo.getErrorCode()" + AsnUtil.intValue((Integer)querErrInfo.getErrorCode()));
            }
        }
        catch (Exception e) {
            this.getLogger().error("query bfd session[" + Bfdmo.getDevID() + "] failed", (Throwable)e);
            return null;
        }
        return queryContext.getQueryResult(BfdCfgSession.class);
    }

    private Collection<QAsnBfdInfo> translateBfdCfgSessionLst(Collection<BfdCfgSession> bfdSessinLst, QAsnGetBfdInfoByKeyRsp rsp) {
        try {
            QAsnBfdInfoTranslator translator = new QAsnBfdInfoTranslator();
            ArrayList<QAsnBfdInfo> bfdAsnLst = new ArrayList<QAsnBfdInfo>();
            AsnTranslationContext context = new AsnTranslationContext();
            for (BfdCfgSession bfdCfgSess : bfdSessinLst) {
                Collection<BfdAllSession> bfdAllSessions;
                QAsnBfdInfo bfdInfo = new QAsnBfdInfo();
                translator.encode(bfdCfgSess, bfdInfo, (IAsnTranslationContext)context);
                this.getLogger().error("GetBfdInfoByKeyTask, befor queryBfdLocalAndRemoteIDFromDev");
                if (-1 == bfdInfo.iLocalID && !CollectionUtils.isEmpty(bfdAllSessions = this.queryBfdAllSessionInfo(bfdInfo))) {
                    BfdAllSession bfdAllSession = bfdAllSessions.iterator().next();
                    if (null != bfdAllSession && -1 != bfdAllSession.getLocalDiscr()) {
                        bfdInfo.iLocalID = bfdAllSession.getLocalDiscr();
                        this.getLogger().error("QueryBfdInfoByDevIDTask.executeTask(), LocalID\uff1a" + bfdAllSession.getLocalDiscr() + " sessionname\uff1a" + bfdAllSession.getSessName());
                    }
                    if (null != bfdAllSession && -1 != bfdAllSession.getRemoteDiscr()) {
                        bfdInfo.iRemoteID = bfdAllSession.getRemoteDiscr();
                        this.getLogger().error("QueryBfdInfoByDevIDTask.executeTask(), RemoteID\uff1a" + bfdAllSession.getLocalDiscr() + " sessionname\uff1a" + bfdAllSession.getSessName());
                    }
                }
                bfdAsnLst.add(bfdInfo);
            }
            return bfdAsnLst;
        }
        catch (VMFException e) {
            this.getLogger().error("mo(BfdCfgSession) translate to asn(QAsnBfdInfo) failed", (Throwable)e);
            return null;
        }
    }

    private Collection<BfdAllSession> queryBfdLocalAndRemoteIDFromDev(QAsnBfdInfo asnBfd, QAsnGetBfdInfoByKeyRsp rsp) {
        BfdAllSession mo = new BfdAllSession();
        mo.setDevID(Integer.valueOf(asnBfd.neID));
        mo.setSessName(AsnUtil.strValue((byte[])asnBfd.strName));
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(mo.getDevID().intValue());
        queryContext.addQueryAttributes(FeatureName.BFD, (VmfMO)mo, null);
        pollService.addQueryJob(queryContext);
        try {
            pollService.poll();
            ErrorInfo querErrInfo = pollService.getErrorInfo((VmfMO)mo);
            if (querErrInfo != null && 0 != querErrInfo.getErrorCode()) {
                rsp.oResult.retCode = querErrInfo.getErrorCode();
                rsp.oResult.reason = null == querErrInfo.getErrorMessage() ? "".getBytes() : querErrInfo.getErrorMessage().getBytes();
                this.getLogger().error("queryBfdLocalAndRemoteIDFromDev errorInfo.getErrorCode()" + AsnUtil.intValue((Integer)querErrInfo.getErrorCode()));
            }
        }
        catch (Exception e) {
            this.getLogger().error("queryBfdLocalAndRemoteIDFromDev[" + mo.getDevID() + "] failed", (Throwable)e);
            asnBfd.poOperResult.isSuccess = false;
            return null;
        }
        return queryContext.getQueryResult(BfdAllSession.class);
    }

    private Collection<BfdCfgSession> queryBfdInfoByKey(QAsnUniResID uniResID) {
        ArrayList<Integer> lstDevID = new ArrayList<Integer>();
        lstDevID.add(uniResID.neID);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            ArrayList<BfdCfgSession> conditions = new ArrayList<BfdCfgSession>();
            BfdKeyParser parser = new BfdKeyParser();
            BfdCfgSession bfdCfgMo = new BfdCfgSession();
            bfdCfgMo.setDevID(Integer.valueOf(uniResID.neID));
            String strfdn = StringUtil.globalString((byte[])uniResID.strFDN);
            if (StringUtils.hasText((String)strfdn)) {
                parser.deserialize(strfdn);
                bfdCfgMo.setSessName(parser.getBfdName());
            }
            conditions.add(bfdCfgMo);
            String[] fieldNames = new String[]{"devID", "sessName"};
            Collection bfdInfo = dao.queryByNeID(BfdCfgSession.class, lstDevID, fieldNames, conditions, true);
            return bfdInfo;
        }
        catch (VMFException e) {
            this.getLogger().error("GetBfdInfoByKeyTask.queryBfdInfoByKey(),query BfdCfgSession by key failed", (Throwable)e);
            return null;
        }
    }

    private Collection<BfdAllSession> queryBfdAllSessionInfo(QAsnBfdInfo bfdDetailInfo) {
        try {
            ArrayList<Integer> lstDevID = new ArrayList<Integer>();
            lstDevID.add(bfdDetailInfo.neID);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            ArrayList<BfdAllSession> conditions = new ArrayList<BfdAllSession>();
            BfdAllSession bfdCfgSe = new BfdAllSession();
            bfdCfgSe.setDevID(Integer.valueOf(bfdDetailInfo.neID));
            bfdCfgSe.setSessName(AsnUtil.strValue((byte[])bfdDetailInfo.strName));
            conditions.add(bfdCfgSe);
            String[] fieldNames = new String[]{"devID", "sessName"};
            Collection bfdInfo = dao.queryByNeID(BfdAllSession.class, lstDevID, fieldNames, conditions, true);
            return bfdInfo;
        }
        catch (VMFException e) {
            this.getLogger().error("query BfdAllSession by devID failed", (Throwable)e);
            return null;
        }
    }
}

