/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdKeyForVr;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdKeyForVrList;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnGetBFDInfoForVrReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnGetBFDInfoForVrRsp;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdInfoTranslator;
import com.huawei.vmf.adapter.bfd.util.BfdKeyParser;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdAllSession;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GetBFDInfoForVrTask
extends AbstractQTask<QAsnGetBFDInfoForVrReq, QAsnGetBFDInfoForVrRsp> {
    public Collection<BfdCfgSession> queryBfdInfo(QAsnBfdKeyForVrList lstVrKey) {
        HashSet<BfdCfgSession> bfdSessionlist = new HashSet<BfdCfgSession>();
        if (!CollectionUtils.isEmpty((Collection)lstVrKey)) {
            for (Object obj : lstVrKey) {
                QAsnBfdKeyForVr bfdVrKey = (QAsnBfdKeyForVr)obj;
                QAsnUniResID fdn = bfdVrKey.poBfdKey;
                Collection<BfdCfgSession> instances = this.queryBfdInfoByKey(fdn);
                bfdSessionlist.addAll(instances);
            }
        }
        return bfdSessionlist;
    }

    protected void executeTask(QAsnGetBFDInfoForVrReq req, QAsnGetBFDInfoForVrRsp rsp, Task task) {
        try {
            Collection<Object> bfdSessions = new ArrayList();
            if (null == req.lstBfdVrKey) {
                this.getLogger().error("req.lstBfdVrKey(QAsnGetBFDInfoForVrReq) is null");
                return;
            }
            bfdSessions = this.queryBfdInfo(req.lstBfdVrKey);
            if (CollectionUtils.isEmpty(bfdSessions)) {
                this.getLogger().error("bfdSessions is null");
                return;
            }
            for (BfdCfgSession bfdCfgSession : bfdSessions) {
                Collection<BfdAllSession> bfdAllSessions;
                QAsnBfdInfoTranslator bfdInfoTranslator = new QAsnBfdInfoTranslator();
                AsnTranslationContext context = new AsnTranslationContext();
                QAsnBfdInfo bfdInfo = new QAsnBfdInfo();
                bfdInfo.poOperResult = new QAsnSingleReturn();
                bfdInfoTranslator.encode(bfdCfgSession, bfdInfo, (IAsnTranslationContext)context);
                if (-1 == bfdInfo.iLocalID && !CollectionUtils.isEmpty(bfdAllSessions = this.queryBfdAllSessionInfo(bfdInfo))) {
                    BfdAllSession bfdAllSession = bfdAllSessions.iterator().next();
                    if (null != bfdAllSession && -1 != bfdAllSession.getLocalDiscr()) {
                        bfdInfo.iLocalID = bfdAllSession.getLocalDiscr();
                        this.getLogger().error("GetBFDInfoForVrTask.executeTask(), LocalID\uff1a" + bfdAllSession.getLocalDiscr() + " sessionname\uff1a" + bfdAllSession.getSessName());
                    }
                    if (null != bfdAllSession && -1 != bfdAllSession.getRemoteDiscr()) {
                        bfdInfo.iRemoteID = bfdAllSession.getRemoteDiscr();
                        this.getLogger().error("GetBFDInfoForVrTask.executeTask(), RemoteID\uff1a" + bfdAllSession.getLocalDiscr() + " sessionname\uff1a" + bfdAllSession.getSessName());
                    }
                }
                bfdInfo.poOperResult.isSuccess = true;
                rsp.lstBfdInfo.add((Object)bfdInfo);
            }
            rsp.oResult.isSuccess = true;
        }
        catch (VMFException e) {
            rsp.oResult.isSuccess = false;
            rsp.oResult.retCode = 1107499878;
            rsp.oResult.reason = e.getErrorMessage().getBytes();
            this.getLogger().error("GetBFDInfoForVrTask, mo(BfdCfgSession) translate to asn(QAsnBfdInfo) failed");
        }
    }

    private Collection<BfdAllSession> queryBfdAllSessionInfo(QAsnBfdInfo bfdDetailInfo) {
        try {
            ArrayList<Integer> lstDevID = new ArrayList<Integer>();
            lstDevID.add(bfdDetailInfo.neID);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection bfdInfo = null;
            ArrayList<BfdAllSession> conditions = new ArrayList<BfdAllSession>();
            BfdAllSession bfdCfgSe = new BfdAllSession();
            bfdCfgSe.setDevID(Integer.valueOf(bfdDetailInfo.neID));
            bfdCfgSe.setSessName(AsnUtil.strValue((byte[])bfdDetailInfo.strName));
            conditions.add(bfdCfgSe);
            String[] fieldNames = new String[]{"devID", "sessName"};
            bfdInfo = dao.queryByNeID(BfdAllSession.class, lstDevID, fieldNames, conditions, true);
            return bfdInfo;
        }
        catch (VMFException e) {
            this.getLogger().error("query BfdAllSession by devID failed", (Throwable)e);
            return null;
        }
    }

    private Collection<BfdCfgSession> queryBfdInfoByKey(QAsnUniResID uniResID) {
        ArrayList<Integer> lstDevID = new ArrayList<Integer>();
        lstDevID.add(uniResID.neID);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection bfdInfo = null;
        try {
            ArrayList<BfdCfgSession> conditions = new ArrayList<BfdCfgSession>();
            BfdKeyParser parser = new BfdKeyParser();
            BfdCfgSession bfdCfgMo = new BfdCfgSession();
            bfdCfgMo.setDevID(Integer.valueOf(uniResID.neID));
            String strfdn = StringUtil.globalString((byte[])uniResID.strFDN);
            if (StringUtils.hasText((String)strfdn)) {
                parser.deserialize(strfdn);
                bfdCfgMo.setSessName(parser.getBfdName());
            }
            conditions.add(bfdCfgMo);
            String[] fieldNames = new String[]{"devID", "sessName"};
            bfdInfo = dao.queryByNeID(BfdCfgSession.class, lstDevID, fieldNames, conditions, true);
            return bfdInfo;
        }
        catch (VMFException e) {
            this.getLogger().error("GetBfdInfoByKeyTask.queryBfdInfoByKey(),query BfdCfgSession by key failed", (Throwable)e);
            return null;
        }
    }
}

